/// <reference path="./internal_*.d.ts" />
declare namespace Internal {
    class AccessibleRelation extends Internal.AccessibleBundle {
        constructor(arg0: string, arg1: any)
        constructor(arg0: string, arg1: any[])
        constructor(arg0: string)
        getKey(): string;
        getTarget(): any[];
        setTarget(arg0: any): void;
        setTarget(arg0: any[]): void;
        get key(): string
        get target(): any[]
        set target(arg0: any)
        set target(arg0: any[])
        static readonly CONTROLLER_FOR: "controllerFor";
        static readonly MEMBER_OF: "memberOf";
        static readonly EMBEDS_PROPERTY: "embedsProperty";
        static readonly LABELED_BY: "labeledBy";
        static readonly SUBWINDOW_OF_PROPERTY: "subwindowOfProperty";
        static readonly CONTROLLED_BY_PROPERTY: "controlledByProperty";
        static readonly SUBWINDOW_OF: "subwindowOf";
        static readonly EMBEDDED_BY: "embeddedBy";
        static readonly LABEL_FOR: "labelFor";
        static readonly LABELED_BY_PROPERTY: "labeledByProperty";
        static readonly PARENT_WINDOW_OF: "parentWindowOf";
        static readonly CHILD_NODE_OF: "childNodeOf";
        static readonly LABEL_FOR_PROPERTY: "labelForProperty";
        static readonly FLOWS_TO_PROPERTY: "flowsToProperty";
        static readonly CONTROLLER_FOR_PROPERTY: "controllerForProperty";
        static readonly EMBEDS: "embeds";
        static readonly EMBEDDED_BY_PROPERTY: "embeddedByProperty";
        static readonly CHILD_NODE_OF_PROPERTY: "childNodeOfProperty";
        static readonly CONTROLLED_BY: "controlledBy";
        static readonly FLOWS_FROM: "flowsFrom";
        static readonly FLOWS_TO: "flowsTo";
        static readonly PARENT_WINDOW_OF_PROPERTY: "parentWindowOfProperty";
        static readonly MEMBER_OF_PROPERTY: "memberOfProperty";
        static readonly FLOWS_FROM_PROPERTY: "flowsFromProperty";
    }
    type AccessibleRelation_ = AccessibleRelation;
    class DataFetcher {
        constructor($$0: Internal.Executor_, $$1: Internal.TimeUnit_, $$2: any_)
        createTask<T>($$0: string, $$1: Internal.Callable_<T>, $$2: Duration_, $$3: Internal.RepeatedDelayStrategy_): Internal.DataFetcher$Task<T>;
        createSubscription(): Internal.DataFetcher$Subscription;
    }
    type DataFetcher_ = DataFetcher;
    class WaterWheelStructuralBlock extends Internal.DirectionalBlock implements com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.CustomHitEffectsBlock, Internal.IProxyHoveringInformation, Internal.MultiPosDestructionHandler, Internal.CustomLandingEffectsBlock, Internal.CustomDestroyEffectsBlock {
        constructor(p_52591_: Internal.BlockBehaviour$Properties_)
        stillValid(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, directlyAdjacent: boolean): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        static getMaster(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_): BlockPos;
        setDestroySpeed(v: number): void;
        getExtraPositions(level: Internal.ClientLevel_, pos: BlockPos_, blockState: Internal.BlockState_, progress: number): Internal.Set<BlockPos>;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        getInformationSource(level: Internal.Level_, pos: BlockPos_, state: Internal.BlockState_): BlockPos;
        emi(amount: number): Internal.EmiStack;
        addDestroyEffects(state: Internal.BlockState_, Level: Internal.ClientLevel_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type WaterWheelStructuralBlock_ = WaterWheelStructuralBlock;
    interface ClientboundPlayerAbilitiesPacketAccessor {
        abstract port_lib$setFlyingSpeed(arg0: number): void;
        (arg0: number): void;
    }
    type ClientboundPlayerAbilitiesPacketAccessor_ = ClientboundPlayerAbilitiesPacketAccessor;
    class BigItemStack {
        constructor(stack: Internal.ItemStack_, count: number)
        constructor(stack: Internal.ItemStack_)
        write(): Internal.CompoundTag;
        isInfinite(): boolean;
        static duplicateWrappers(list: Internal.List_<Internal.BigItemStack>): Internal.List<Internal.BigItemStack>;
        static read(tag: Internal.CompoundTag_): Internal.BigItemStack;
        static comparator(): Internal.Comparator<Internal.BigItemStack>;
        send(buffer: Internal.FriendlyByteBuf_): void;
        static receive(buffer: Internal.FriendlyByteBuf_): Internal.BigItemStack;
        get infinite(): boolean
        stack: Internal.ItemStack;
        count: number;
        static readonly INF: 1000000000;
    }
    type BigItemStack_ = BigItemStack;
    class CondenserBlock extends Internal.AEBaseEntityBlock<any> {
        constructor()
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type CondenserBlock_ = CondenserBlock;
    abstract class ServerboundMovePlayerPacket implements Internal.Packet<Internal.ServerGamePacketListener> {
        handle(arg0: Internal.PacketListener_): void;
        abstract write(arg0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ServerGamePacketListener_): void;
        hasRotation(): boolean;
        isOnGround(): boolean;
        getYRot($$0: number): number;
        getX($$0: number): number;
        getY($$0: number): number;
        getZ($$0: number): number;
        hasPosition(): boolean;
        isSkippable(): boolean;
        getXRot($$0: number): number;
        get onGround(): boolean
        get skippable(): boolean
    }
    type ServerboundMovePlayerPacket_ = ServerboundMovePlayerPacket;
    class WindmillBearingBlock extends Internal.BearingBlock implements Internal.IBE<Internal.WindmillBearingBlockEntity> {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        getBlockEntityType(): Internal.BlockEntityType<Internal.WindmillBearingBlockEntity>;
        setDestroySpeed(v: number): void;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.WindmillBearingBlockEntity>): void;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.WindmillBearingBlockEntity;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.WindmillBearingBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        emi(amount: number): Internal.EmiStack;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.WindmillBearingBlockEntity>;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        getBlockEntityClass(): typeof Internal.WindmillBearingBlockEntity;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get blockEntityType(): Internal.BlockEntityType<Internal.WindmillBearingBlockEntity>
        set destroySpeed(v: number)
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
        get blockEntityClass(): typeof Internal.WindmillBearingBlockEntity
    }
    type WindmillBearingBlock_ = WindmillBearingBlock;
    class MechanicalBearingBlockEntity extends Internal.GeneratingKineticBlockEntity implements Internal.IDisplayAssemblyExceptions, Internal.IBearingBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        syncComponent(key: Internal.ComponentKey_<any>): void;
        getAngularSpeed(): number;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        write(compound: Internal.CompoundTag_, clientPacket: boolean): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        isNearInitialAngle(): boolean;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getBlockPosition(): BlockPos;
        assemble(): void;
        addExceptionToTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>): boolean;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        isValid(): boolean;
        invalidateCaps(): void;
        isRunning(): boolean;
        getMovedContraption(): Internal.ControlledContraptionEntity;
        getMovementModeSlot(): Internal.ValueBoxTransform;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        isWoodenTop(): boolean;
        getInterpolatedAngle(partialTicks: number): number;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isAttachedTo(contraption: Internal.AbstractContraptionEntity_): boolean;
        setAngle(forcedAngle: number): void;
        getInfiniteBoundingBox(): Internal.AABB;
        attach(contraption: Internal.ControlledContraptionEntity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        disassemble(): void;
        onStall(): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getLastAssemblyException(): Internal.AssemblyException;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getRenderBoundingBox(): Internal.AABB;
        get angularSpeed(): number
        get nearInitialAngle(): boolean
        get blockPosition(): BlockPos
        get valid(): boolean
        get running(): boolean
        get movedContraption(): Internal.ControlledContraptionEntity
        get movementModeSlot(): Internal.ValueBoxTransform
        get woodenTop(): boolean
        set angle(forcedAngle: number)
        get infiniteBoundingBox(): Internal.AABB
        get lastAssemblyException(): Internal.AssemblyException
        get renderBoundingBox(): Internal.AABB
    }
    type MechanicalBearingBlockEntity_ = MechanicalBearingBlockEntity;
    class WhistleBlock extends Internal.Block implements com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.IBE<Internal.WhistleBlockEntity> {
        constructor(p_49795_: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.WhistleBlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        static incrementSize(pLevel: Internal.LevelAccessor_, pPos: BlockPos_): void;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.WhistleBlockEntity>;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.WhistleBlockEntity>): void;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockEntityClass(): typeof Internal.WhistleBlockEntity;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.WhistleBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        static queuePitchUpdate(level: Internal.LevelAccessor_, pos: BlockPos_): void;
        emi(amount: number): Internal.EmiStack;
        static getAttachedDirection(state: Internal.BlockState_): Internal.Direction;
        getBlockEntityType(): Internal.BlockEntityType<Internal.WhistleBlockEntity>;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get blockEntityClass(): typeof Internal.WhistleBlockEntity
        get blockEntityType(): Internal.BlockEntityType<Internal.WhistleBlockEntity>
        static readonly SIZE: Internal.EnumProperty<Internal.WhistleBlock$WhistleSize>;
        static readonly WALL: Internal.BooleanProperty;
        static readonly FACING: Internal.DirectionProperty;
        static readonly POWERED: Internal.BooleanProperty;
    }
    type WhistleBlock_ = WhistleBlock;
    class FancyTrunkPlacer extends Internal.TrunkPlacer {
        constructor($$0: number, $$1: number, $$2: number)
        static readonly CODEC: Internal.Codec<Internal.FancyTrunkPlacer>;
    }
    type FancyTrunkPlacer_ = FancyTrunkPlacer;
    interface Short2CharFunction extends Internal.IntUnaryOperator, it.unimi.dsi.fastutil.Function<number, string> {
        /**
         * @deprecated
        */
        put(arg0: number, arg1: string): string;
        composeLong(arg0: Internal.Long2ShortFunction_): Internal.Long2CharFunction;
        put(arg0: number, arg1: string): string;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: string): string;
        abstract get(arg0: number): string;
        andThenLong(arg0: Internal.Char2LongFunction_): Internal.Short2LongFunction;
        andThenShort(arg0: Internal.Char2ShortFunction_): Internal.Short2ShortFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        composeObject<T>(arg0: Internal.Object2ShortFunction_<T>): Internal.Object2CharFunction<T>;
        defaultReturnValue(): string;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, string>;
        andThen(arg0: Internal.IntUnaryOperator_): Internal.IntUnaryOperator;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        apply(arg0: number): string;
        andThenFloat(arg0: Internal.Char2FloatFunction_): Internal.Short2FloatFunction;
        remove(arg0: number): string;
        compose(arg0: Internal.IntUnaryOperator_): Internal.IntUnaryOperator;
        /**
         * @deprecated
        */
        applyAsInt(arg0: number): number;
        composeInt(arg0: Internal.Int2ShortFunction_): Internal.Int2CharFunction;
        defaultReturnValue(arg0: string): void;
        identity(): Internal.IntUnaryOperator;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        andThenReference<T>(arg0: Internal.Char2ReferenceFunction_<T>): Internal.Short2ReferenceFunction<T>;
        composeReference<T>(arg0: Internal.Reference2ShortFunction_<T>): Internal.Reference2CharFunction<T>;
        containsKey(arg0: number): boolean;
        getOrDefault(arg0: number, arg1: string): string;
        composeByte(arg0: Internal.Byte2ShortFunction_): Internal.Byte2CharFunction;
        composeShort(arg0: Internal.Short2ShortFunction_): this;
        andThenObject<T>(arg0: Internal.Char2ObjectFunction_<T>): Internal.Short2ObjectFunction<T>;
        andThenDouble(arg0: Internal.Char2DoubleFunction_): Internal.Short2DoubleFunction;
        andThenChar(arg0: Internal.Char2CharFunction_): this;
        composeDouble(arg0: Internal.Double2ShortFunction_): Internal.Double2CharFunction;
        size(): number;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<string, T>): Internal.Function<number, T>;
        composeFloat(arg0: Internal.Float2ShortFunction_): Internal.Float2CharFunction;
        clear(): void;
        andThenInt(arg0: Internal.Char2IntFunction_): Internal.Short2IntFunction;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        andThenByte(arg0: Internal.Char2ByteFunction_): Internal.Short2ByteFunction;
        composeChar(arg0: Internal.Char2ShortFunction_): Internal.Char2CharFunction;
        (arg0: number): string;
    }
    type Short2CharFunction_ = Short2CharFunction;
    abstract class FileSystem implements Internal.Closeable {
        abstract getSeparator(): string;
        abstract getRootDirectories(): Internal.Iterable<Internal.Path>;
        abstract supportedFileAttributeViews(): Internal.Set<string>;
        abstract isOpen(): boolean;
        abstract getFileStores(): Internal.Iterable<Internal.FileStore>;
        abstract newWatchService(): Internal.WatchService;
        abstract close(): void;
        abstract getUserPrincipalLookupService(): Internal.UserPrincipalLookupService;
        abstract provider(): Internal.FileSystemProvider;
        abstract getPath(arg0: string, ...arg1: string[]): Internal.Path;
        abstract isReadOnly(): boolean;
        abstract getPathMatcher(arg0: string): Internal.PathMatcher;
        get separator(): string
        get rootDirectories(): Internal.Iterable<Internal.Path>
        get open(): boolean
        get fileStores(): Internal.Iterable<Internal.FileStore>
        get userPrincipalLookupService(): Internal.UserPrincipalLookupService
        get readOnly(): boolean
    }
    type FileSystem_ = FileSystem;
    class WindowEvent extends Internal.ComponentEvent {
        constructor(arg0: Internal.Window_, arg1: number)
        constructor(arg0: Internal.Window_, arg1: number, arg2: Internal.Window_)
        constructor(arg0: Internal.Window_, arg1: number, arg2: number, arg3: number)
        constructor(arg0: Internal.Window_, arg1: number, arg2: Internal.Window_, arg3: number, arg4: number)
        getNewState(): number;
        getWindow(): Internal.Window;
        getOppositeWindow(): Internal.Window;
        getOldState(): number;
        get newState(): number
        get window(): Internal.Window
        get oppositeWindow(): Internal.Window
        get oldState(): number
        static readonly WINDOW_LAST: 209;
        static readonly WINDOW_LOST_FOCUS: 208;
        static readonly WINDOW_STATE_CHANGED: 209;
        static readonly WINDOW_ACTIVATED: 205;
        static readonly WINDOW_FIRST: 200;
        static readonly WINDOW_DEICONIFIED: 204;
        static readonly WINDOW_GAINED_FOCUS: 207;
        static readonly WINDOW_ICONIFIED: 203;
        static readonly WINDOW_OPENED: 200;
        static readonly WINDOW_CLOSED: 202;
        static readonly WINDOW_DEACTIVATED: 206;
        static readonly WINDOW_CLOSING: 201;
    }
    type WindowEvent_ = WindowEvent;
    interface VanillaToolActionItem {
        abstract port_lib$canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        (arg0: Internal.ItemStack, arg1: Internal.ToolAction): boolean;
    }
    type VanillaToolActionItem_ = VanillaToolActionItem;
    class CraterWorldCarver extends Internal.WorldCarver<Internal.CarverConfiguration> {
        constructor(codec: Internal.Codec_<Internal.CarverConfiguration>)
    }
    type CraterWorldCarver_ = CraterWorldCarver;
    class BeltInventory$ToInsertSnapshotParticipant extends Internal.SnapshotParticipant<Internal.List<Internal.TransportedItemStack>> {
        constructor(this$0: Internal.BeltInventory_)
    }
    type BeltInventory$ToInsertSnapshotParticipant_ = BeltInventory$ToInsertSnapshotParticipant;
    class RecipeManager extends Internal.SimpleJsonResourceReloadListener implements Internal.AccessorRecipeManager, io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.RecipeManagerAccessor, Internal.RecipeManagerAccessor, Internal.IdentifiableResourceReloadListener {
        constructor()
        getRecipeIds(): Internal.Stream<ResourceLocation>;
        replaceRecipes($$0: Internal.Iterable_<Internal.Recipe<any>>): void;
        port_lib$getRecipes(): Internal.Map<any, any>;
        port_lib$byType(arg0: Internal.RecipeType_<any>): Internal.Map<any, any>;
        getRemainingItemsFor<C extends net.minecraft.world.Container, T extends Internal.Recipe<C>>($$0: Internal.RecipeType_<T>, $$1: C, $$2: Internal.Level_): Internal.NonNullList<Internal.ItemStack>;
        byKey($$0: ResourceLocation_): Internal.Optional<Internal.Recipe<any>>;
        getName(): string;
        getRecipesFor<C extends net.minecraft.world.Container, T extends Internal.Recipe<C>>($$0: Internal.RecipeType_<T>, $$1: C, $$2: Internal.Level_): Internal.List<T>;
        handler$zdi000$porting_lib_base$port_lib$invalidateRecipe(object: Internal.Map_<any, any>, resourceManager: Internal.ResourceManager_, profiler: Internal.ProfilerFiller_, ci: Internal.CallbackInfo_, recipe: Internal.Recipe_<any>, capturedRecipe: Internal.LocalRef_<any>): void;
        byType<C extends net.minecraft.world.Container, T extends Internal.Recipe<C>>($$0: Internal.RecipeType_<T>): Internal.Map<ResourceLocation, T>;
        getFabricId(): ResourceLocation;
        wrapOperation$zdi000$porting_lib_base$port_lib$nullCompute(recipe: Internal.Recipe_<any>, recipeTypeOperation: Internal.Operation_<any>): Internal.RecipeType<any>;
        handler$zdi000$porting_lib_base$port_lib$captureRecipe(object: Internal.Map_<any, any>, resourceManager: Internal.ResourceManager_, profiler: Internal.ProfilerFiller_, ci: Internal.CallbackInfo_, recipe: Internal.Recipe_<any>, capturedRecipe: Internal.LocalRef_<any>): void;
        bookshelf$getTypeMap(arg0: Internal.RecipeType_<any>): Internal.Map<any, any>;
        static createCheck<C extends net.minecraft.world.Container, T extends Internal.Recipe<C>>($$0: Internal.RecipeType_<T>): Internal.RecipeManager$CachedCheck<C, T>;
        getRecipeFor<C extends net.minecraft.world.Container, T extends Internal.Recipe<C>>($$0: Internal.RecipeType_<T>, $$1: C, $$2: Internal.Level_): Internal.Optional<T>;
        getRecipeMap(arg0: Internal.RecipeType_<any>): Internal.Map<any, any>;
        hadErrorsLoading(): boolean;
        getRecipes(): Internal.Collection<Internal.Recipe<any>>;
        getFabricDependencies(): Internal.Collection<any>;
        getAllRecipesFor<C extends net.minecraft.world.Container, T extends Internal.Recipe<C>>($$0: Internal.RecipeType_<T>): Internal.List<T>;
        static fromJson($$0: ResourceLocation_, $$1: Internal.JsonObject_): Internal.Recipe<any>;
        getRecipeFor<C extends net.minecraft.world.Container, T extends Internal.Recipe<C>>($$0: Internal.RecipeType_<T>, $$1: C, $$2: Internal.Level_, $$3: ResourceLocation_): Internal.Optional<com.mojang.datafixers.util.Pair<ResourceLocation, T>>;
        wrapWithCondition$zdi000$porting_lib_base$port_lib$allowNullRecipe(self: Internal.ImmutableMap$Builder_<any, any>, key: any, val: any, capturedRecipe: Internal.LocalRef_<any>): boolean;
        wrapOperation$zdi000$porting_lib_base$port_lib$allowNullMap(map: Internal.Map_<any, any>, obj: any, function_: Internal.Function_<any, any>, operation: Internal.Operation_<any>, capturedRecipe: Internal.LocalRef_<any>): any;
        get recipeIds(): Internal.Stream<ResourceLocation>
        get name(): string
        get fabricId(): ResourceLocation
        get recipes(): Internal.Collection<Internal.Recipe<any>>
        get fabricDependencies(): Internal.Collection<any>
        byName: Internal.Map<ResourceLocation, Internal.Recipe<any>>;
        recipes: Internal.Map<Internal.RecipeType<any>, Internal.Map<ResourceLocation, Internal.Recipe<any>>>;
    }
    type RecipeManager_ = RecipeManager;
    interface SensorAccessor {
        abstract getLastSenseTime(): number;
        abstract getSenseInterval(): number;
        abstract setLastSenseTime(arg0: number): void;
        get lastSenseTime(): number
        get senseInterval(): number
        set lastSenseTime(arg0: number)
    }
    type SensorAccessor_ = SensorAccessor;
    interface AgriGenomeProvider {
        abstract plantGenome(arg0: Internal.AgriGenome_, arg1: Internal.LivingEntity_): void;
        abstract removeGenome(): boolean;
        plantGenome(genome: Internal.AgriGenome_): void;
        abstract getGenome(): Internal.AgriGenome;
        get genome(): Internal.AgriGenome
    }
    type AgriGenomeProvider_ = AgriGenomeProvider;
    interface Spliterator <T> {
        getExactSizeIfKnown(): number;
        forEachRemaining(arg0: Internal.Consumer_<T>): void;
        hasCharacteristics(arg0: number): boolean;
        abstract tryAdvance(arg0: Internal.Consumer_<T>): boolean;
        getComparator(): Internal.Comparator<T>;
        abstract characteristics(): number;
        abstract estimateSize(): number;
        abstract trySplit(): this;
        get exactSizeIfKnown(): number
        get comparator(): Internal.Comparator<T>
        readonly SORTED: 4;
        readonly IMMUTABLE: 1024;
        readonly DISTINCT: 1;
        readonly CONCURRENT: 4096;
        readonly ORDERED: 16;
        readonly NONNULL: 256;
        readonly SUBSIZED: 16384;
        readonly SIZED: 64;
    }
    type Spliterator_<T> = Spliterator<T>;
    class FlowerPotBlock extends Internal.Block {
        constructor($$0: Internal.Block_, $$1: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getContent(): Internal.Block;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get content(): Internal.Block
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly AABB_SIZE: 3.0;
        content: Internal.Block;
    }
    type FlowerPotBlock_ = FlowerPotBlock;
    class ItemModelBuilder$OverrideBuilder {
        constructor(this$0: Internal.ItemModelBuilder_)
        predicate(key: ResourceLocation_, value: number): this;
        end(): Internal.ItemModelBuilder;
        model(model: Internal.ModelFile_): this;
    }
    type ItemModelBuilder$OverrideBuilder_ = ItemModelBuilder$OverrideBuilder;
    class DoublePlantBlockBOP extends Internal.DoublePlantBlock implements Internal.BonemealableBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        isBonemealSuccess(level: Internal.Level_, randomSource: Internal.RandomSource_, blockPos: BlockPos_, blockState: Internal.BlockState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        performBonemeal(serverLevel: Internal.ServerLevel_, randomSource: Internal.RandomSource_, blockPos: BlockPos_, blockState: Internal.BlockState_): void;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        isValidBonemealTarget(levelReader: Internal.LevelReader_, blockPos: BlockPos_, blockState: Internal.BlockState_, b: boolean): boolean;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type DoublePlantBlockBOP_ = DoublePlantBlockBOP;
    class LanguageInfo extends Internal.Record {
        constructor($$0: string, $$1: string, $$2: boolean)
        name(): string;
        toComponent(): net.minecraft.network.chat.Component;
        bidirectional(): boolean;
        region(): string;
        static readonly CODEC: Internal.Codec<Internal.LanguageInfo>;
    }
    type LanguageInfo_ = LanguageInfo;
    class MobSpawnType extends Internal.Enum<Internal.MobSpawnType> {
        static valueOf($$0: string): Internal.MobSpawnType;
        static values(): Internal.MobSpawnType[];
        static readonly SPAWNER: Internal.MobSpawnType;
        static readonly BREEDING: Internal.MobSpawnType;
        static readonly CHUNK_GENERATION: Internal.MobSpawnType;
        static readonly EVENT: Internal.MobSpawnType;
        static readonly MOB_SUMMONED: Internal.MobSpawnType;
        static readonly CONVERSION: Internal.MobSpawnType;
        static readonly TRIGGERED: Internal.MobSpawnType;
        static readonly COMMAND: Internal.MobSpawnType;
        static readonly STRUCTURE: Internal.MobSpawnType;
        static readonly JOCKEY: Internal.MobSpawnType;
        static readonly PATROL: Internal.MobSpawnType;
        static readonly DISPENSER: Internal.MobSpawnType;
        static readonly REINFORCEMENT: Internal.MobSpawnType;
        static readonly BUCKET: Internal.MobSpawnType;
        static readonly SPAWN_EGG: Internal.MobSpawnType;
        static readonly NATURAL: Internal.MobSpawnType;
    }
    type MobSpawnType_ = "bucket" | "spawner" | "chunk_generation" | "spawn_egg" | "triggered" | "breeding" | "dispenser" | "mob_summoned" | "reinforcement" | "event" | "patrol" | "jockey" | "command" | "natural" | MobSpawnType | "structure" | "conversion";
    class TankItem extends Internal.BlockTooltipItem implements Internal.CustomMaxCountItem {
        constructor(blockIn: Internal.Block_, builder: Internal.Item$Properties_, limitStackSize: boolean)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        static setTank(stack: Internal.ItemStack_, tank: io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getItemStackLimit(stack: Internal.ItemStack_): number;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        static getFluidTank(stack: Internal.ItemStack_): io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type TankItem_ = TankItem;
    class DamageType extends Internal.Record {
        constructor($$0: string, $$1: Internal.DamageScaling_, $$2: number, $$3: Internal.DamageEffects_)
        constructor($$0: string, $$1: Internal.DamageScaling_, $$2: number)
        constructor($$0: string, $$1: number, $$2: Internal.DamageEffects_)
        constructor($$0: string, $$1: Internal.DamageScaling_, $$2: number, $$3: Internal.DamageEffects_, $$4: Internal.DeathMessageType_)
        constructor($$0: string, $$1: number)
        scaling(): Internal.DamageScaling;
        deathMessageType(): Internal.DeathMessageType;
        exhaustion(): number;
        effects(): Internal.DamageEffects;
        msgId(): string;
        static readonly CODEC: Internal.Codec<Internal.DamageType>;
    }
    type DamageType_ = Special.DamageType | DamageType;
    abstract class TextureSheetParticle extends Internal.SingleQuadParticle implements io.github.fabricators_of_create.porting_lib.models.mixin.client.TextureSheetParticleAccessor, Internal.TextureSheetParticleAccessor {
        static tickEntity(entity: Internal.Entity_): void;
        pickSprite($$0: Internal.SpriteSet_): void;
        setSprite($$0: Internal.TextureAtlasSprite_): void;
        callSetSprite(arg0: Internal.TextureAtlasSprite_): void;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        setSpriteFromAge($$0: Internal.SpriteSet_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        isDynamicLightEnabled(): boolean;
        shouldCull(): boolean;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        porting_lib$setSprite(arg0: Internal.TextureAtlasSprite_): void;
        set sprite($$0: Internal.TextureAtlasSprite_)
        set spriteFromAge($$0: Internal.SpriteSet_)
        set dynamicLightEnabled(enabled: boolean)
        get dynamicLightEnabled(): boolean
    }
    type TextureSheetParticle_ = TextureSheetParticle;
    class Stack <E> extends Internal.Vector<E> {
        constructor()
        empty(): boolean;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.List<E>;
        addLast(arg0: E): void;
        static copyOf<E>(arg0: Internal.Collection_<E>): Internal.List<E>;
        getLast(): E;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.List<E>;
        removeFirst(): E;
        parallelStream(): Internal.Stream<E>;
        static of<E>(arg0: E): Internal.List<E>;
        static of<E>(): Internal.List<E>;
        static of<E>(...arg0: E[]): Internal.List<E>;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        reversed(): Internal.SequencedCollection<any>;
        search(arg0: any): number;
        peek(): E;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.List<E>;
        addFirst(arg0: E): void;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.List<E>;
        pop(): E;
        getFirst(): E;
        static of<E>(arg0: E, arg1: E): Internal.List<E>;
        stream(): Internal.Stream<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.List<E>;
        removeLast(): E;
        push(arg0: E): E;
        get last(): E
        get first(): E
    }
    type Stack_<E> = Stack<E>;
    interface ConcurrentMap <K, V> extends Internal.Map<K, V> {
        computeIfAbsent(arg0: K, arg1: Internal.Function_<K, V>): V;
        abstract replace(arg0: K, arg1: V): V;
        abstract containsValue(arg0: any): boolean;
        computeIfPresent(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        of<K, V>(): Internal.Map<K, V>;
        getOrDefault(arg0: any, arg1: V): V;
        abstract isEmpty(): boolean;
        entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        abstract containsKey(arg0: any): boolean;
        abstract put(arg0: K, arg1: V): V;
        abstract get(arg0: any): V;
        abstract remove(arg0: any): V;
        copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        merge(arg0: K, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
        abstract putIfAbsent(arg0: K, arg1: V): V;
        abstract keySet(): Internal.Set<K>;
        forEach(arg0: Internal.BiConsumer_<K, V>): void;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        compute(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        abstract values(): Internal.Collection<V>;
        abstract entrySet(): Internal.Set<Internal.Map$Entry<K, V>>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        abstract remove(arg0: any, arg1: any): boolean;
        abstract putAll(arg0: Internal.Map_<K, V>): void;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        abstract size(): number;
        abstract hashCode(): number;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        abstract replace(arg0: K, arg1: V, arg2: V): boolean;
        abstract clear(): void;
        replaceAll(arg0: Internal.BiFunction_<K, V, V>): void;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        abstract equals(arg0: any): boolean;
        of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
        get empty(): boolean
    }
    type ConcurrentMap_<K, V> = ConcurrentMap<K, V>;
    abstract class BasePressurePlateBlock extends Internal.Block {
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type BasePressurePlateBlock_ = BasePressurePlateBlock;
    class SpawnSeaSerpent extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(configFactoryIn: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type SpawnSeaSerpent_ = SpawnSeaSerpent;
    abstract class LaunchedItem {
        update(world: Internal.Level_): boolean;
        serializeNBT(): Internal.CompoundTag;
        static fromNBT(c: Internal.CompoundTag_, holderGetter: Internal.HolderGetter_<Internal.Block>): Internal.LaunchedItem;
        totalTicks: number;
        stack: Internal.ItemStack;
        target: BlockPos;
        ticksRemaining: number;
    }
    type LaunchedItem_ = LaunchedItem;
    class ItemEntry <T extends Internal.Item> extends Internal.ItemProviderEntry<T> {
        constructor(owner: Internal.AbstractRegistrate_<any>, delegate: Internal.RegistryObject_<T>)
        static cast<T extends Internal.Item>(entry: Internal.RegistryEntry_<T>): Internal.ItemEntry<T>;
        emi(amount: number): Internal.EmiStack;
        static of<T>(sup: Internal.Supplier_<T>, errorMsg: Internal.NonNullSupplier_<string>): Internal.NonNullSupplier<T>;
        lazy(): Internal.NonNullSupplier<T>;
        static of<T>(sup: Internal.Supplier_<T>): Internal.NonNullSupplier<T>;
        emi(): Internal.EmiStack;
        static lazy<T>(sup: Internal.Supplier_<T>): Internal.NonNullSupplier<T>;
    }
    type ItemEntry_<T extends Internal.Item> = ItemEntry<T>;
    /**
     * Invoked before an entity is spawned into the world.
     * 
     * Only entities from a `BaseSpawner` or world generation will trigger this event.
    */
    class CheckLivingEntitySpawnEventJS extends Internal.LivingEntityEventJS {
        constructor(entity: Internal.LivingEntity_, level: Internal.Level_, x: number, y: number, z: number, type: Internal.MobSpawnType_, spawner: Internal.BaseSpawner_)
        /**
         * The entity being spawned.
        */
        getEntity(): Internal.Entity;
        /**
         * The spawner that spawned the entity. Can be null if the entity was spawned by worldgen.
        */
        getSpawner(): Internal.BaseSpawner;
        /**
         * The type of spawn.
        */
        getType(): Internal.MobSpawnType;
        /**
         * The block the entity is being spawned on.
        */
        getBlock(): Internal.BlockContainerJS;
        /**
         * The entity being spawned.
        */
        get entity(): Internal.Entity
        /**
         * The spawner that spawned the entity. Can be null if the entity was spawned by worldgen.
        */
        get spawner(): Internal.BaseSpawner
        /**
         * The type of spawn.
        */
        get type(): Internal.MobSpawnType
        /**
         * The block the entity is being spawned on.
        */
        get block(): Internal.BlockContainerJS
        readonly z: number;
        readonly spawner: Internal.BaseSpawner;
        readonly type: Internal.MobSpawnType;
        readonly x: number;
        readonly y: number;
    }
    type CheckLivingEntitySpawnEventJS_ = CheckLivingEntitySpawnEventJS;
    abstract class TrackedBlockStatePredicate implements Internal.Predicate<Internal.BlockState> {
        constructor(index: number)
        and(arg0: Internal.Predicate_<Internal.BlockState>): Internal.Predicate<Internal.BlockState>;
        static not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
        abstract test(arg0: Internal.BlockState_): boolean;
        or(arg0: Internal.Predicate_<Internal.BlockState>): Internal.Predicate<Internal.BlockState>;
        negate(): Internal.Predicate<Internal.BlockState>;
        getIndex(): number;
        static isEqual<T>(arg0: any): Internal.Predicate<T>;
        get index(): number
        static readonly FULLY_INITIALIZED: Internal.AtomicBoolean;
    }
    type TrackedBlockStatePredicate_ = TrackedBlockStatePredicate;
    class PipeBlock extends Internal.Block {
        constructor($$0: number, $$1: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly NORTH: Internal.BooleanProperty;
        static readonly PROPERTY_BY_DIRECTION: {[key: Internal.Direction]: Internal.BooleanProperty, [key: Internal.Direction]: Internal.BooleanProperty, [key: Internal.Direction]: Internal.BooleanProperty, [key: Internal.Direction]: Internal.BooleanProperty, [key: Internal.Direction]: Internal.BooleanProperty, [key: Internal.Direction]: Internal.BooleanProperty};
        static readonly SOUTH: Internal.BooleanProperty;
        static readonly UP: Internal.BooleanProperty;
        static readonly WEST: Internal.BooleanProperty;
        static readonly DOWN: Internal.BooleanProperty;
        static readonly EAST: Internal.BooleanProperty;
    }
    type PipeBlock_ = PipeBlock;
    interface ListenableRegistry <T> {
        get<T>(registry: Internal.Registry_<T>): this;
        abstract fabric_getRemapEvent(): net.fabricmc.fabric.api.event.Event<Internal.RegistryIdRemapCallback<T>>;
        abstract fabric_getAddObjectEvent(): net.fabricmc.fabric.api.event.Event<Internal.RegistryEntryAddedCallback<T>>;
        abstract fabric_getRemoveObjectEvent(): net.fabricmc.fabric.api.event.Event<Internal.RegistryEntryRemovedCallback<T>>;
    }
    type ListenableRegistry_<T> = ListenableRegistry<T>;
    class TickRateModulation extends Internal.Enum<Internal.TickRateModulation> {
        static valueOf(name: string): Internal.TickRateModulation;
        static values(): Internal.TickRateModulation[];
        static readonly SLOWER: Internal.TickRateModulation;
        static readonly URGENT: Internal.TickRateModulation;
        static readonly SAME: Internal.TickRateModulation;
        static readonly SLEEP: Internal.TickRateModulation;
        static readonly IDLE: Internal.TickRateModulation;
        static readonly FASTER: Internal.TickRateModulation;
    }
    type TickRateModulation_ = "slower" | "faster" | TickRateModulation | "idle" | "urgent" | "same" | "sleep";
    class GorgonTempleStructure extends Internal.IafJigsawStructure {
        constructor(config: Internal.Structure$StructureSettings_, startPool: Internal.Holder_<Internal.StructureTemplatePool>, startJigsawName: Internal.Optional_<ResourceLocation>, size: number, startHeight: Internal.HeightProvider_, projectStartToHeightmap: Internal.Optional_<Internal.Heightmap$Types>, maxDistanceFromCenter: number)
        static readonly CODEC: Internal.Codec<Internal.GorgonTempleStructure>;
    }
    type GorgonTempleStructure_ = GorgonTempleStructure;
    abstract class RhinoException extends Internal.RuntimeException {
        details(): string;
        sourceName(): string;
        getScriptStackTrace(limit: number, functionName: string): string;
        initSourceName(sourceName: string): void;
        getScriptStackTrace(): string;
        lineSource(): string;
        initLineNumber(lineNumber: number): void;
        columnNumber(): number;
        getScriptStack(): any[];
        lineNumber(): number;
        initColumnNumber(columnNumber: number): void;
        initLineSource(lineSource: string): void;
        getScriptStack(limit: number, hideFunction: string): any[];
        get scriptStackTrace(): string
        get scriptStack(): any[]
    }
    type RhinoException_ = RhinoException;
    class NearestVisibleLivingEntities {
        constructor($$0: Internal.LivingEntity_, $$1: Internal.List_<Internal.LivingEntity>)
        findClosest($$0: Internal.Predicate_<Internal.LivingEntity>): Internal.Optional<Internal.LivingEntity>;
        contains($$0: Internal.Predicate_<Internal.LivingEntity>): boolean;
        contains($$0: Internal.LivingEntity_): boolean;
        static empty(): Internal.NearestVisibleLivingEntities;
        findAll($$0: Internal.Predicate_<Internal.LivingEntity>): Internal.Iterable<Internal.LivingEntity>;
        find($$0: Internal.Predicate_<Internal.LivingEntity>): Internal.Stream<Internal.LivingEntity>;
    }
    type NearestVisibleLivingEntities_ = NearestVisibleLivingEntities;
    class ServerboundChatCommandPacket extends Internal.Record implements Internal.Packet<Internal.ServerGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: string, $$1: Internal.Instant_, $$2: number, $$3: Internal.ArgumentSignatures_, $$4: Internal.LastSeenMessages$Update_)
        handle(arg0: Internal.PacketListener_): void;
        argumentSignatures(): Internal.ArgumentSignatures;
        write($$0: Internal.FriendlyByteBuf_): void;
        timeStamp(): Internal.Instant;
        command(): string;
        handle($$0: Internal.ServerGamePacketListener_): void;
        salt(): number;
        lastSeenMessages(): Internal.LastSeenMessages$Update;
        isSkippable(): boolean;
        get skippable(): boolean
    }
    type ServerboundChatCommandPacket_ = ServerboundChatCommandPacket;
    interface BlockEntityExtensions {
        invalidateCaps(): void;
        getCustomData(): Internal.CompoundTag;
        onLoad(): void;
        deserializeNBT(state: Internal.BlockState_, nbt: Internal.CompoundTag_): void;
        get customData(): Internal.CompoundTag
    }
    type BlockEntityExtensions_ = BlockEntityExtensions;
    class ChestLootEventJS extends Internal.LootEventJS {
        constructor(c: Internal.Map_<ResourceLocation, Internal.JsonElement>)
        addChest(id: ResourceLocation_, b: Internal.Consumer_<Internal.LootBuilder>): void;
    }
    type ChestLootEventJS_ = ChestLootEventJS;
    class AccessibleStateSet {
        constructor()
        constructor(arg0: Internal.AccessibleState_[])
        add(arg0: Internal.AccessibleState_): boolean;
        toArray(): Internal.AccessibleState[];
        clear(): void;
        addAll(arg0: Internal.AccessibleState_[]): void;
        remove(arg0: Internal.AccessibleState_): boolean;
        contains(arg0: Internal.AccessibleState_): boolean;
    }
    type AccessibleStateSet_ = AccessibleStateSet;
    class ComputerComponent <T> {
        static create<T>(namespace: string, id: string): Internal.ComputerComponent<T>;
    }
    type ComputerComponent_<T> = ComputerComponent<T>;
    interface Instancer <I extends Internal.Instance> {
        createInstances(arr: I[]): void;
        abstract createInstance(): I;
        abstract stealInstance(arg0: I): void;
    }
    type Instancer_<I extends Internal.Instance> = Instancer<I>;
    interface Long2LongFunction extends it.unimi.dsi.fastutil.Function<number, number>, Internal.LongUnaryOperator {
        composeObject<T>(arg0: Internal.Object2LongFunction_<T>): Internal.Object2LongFunction<T>;
        composeByte(arg0: Internal.Byte2LongFunction_): Internal.Byte2LongFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<number, T>;
        identity(): this;
        remove(arg0: number): number;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, number>;
        andThenFloat(arg0: Internal.Long2FloatFunction_): Internal.Long2FloatFunction;
        composeChar(arg0: Internal.Char2LongFunction_): Internal.Char2LongFunction;
        andThenChar(arg0: Internal.Long2CharFunction_): Internal.Long2CharFunction;
        /**
         * @deprecated
        */
        get(arg0: any): number;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        getOrDefault(arg0: number, arg1: number): number;
        andThen(arg0: Internal.LongUnaryOperator_): Internal.LongUnaryOperator;
        composeReference<T>(arg0: Internal.Reference2LongFunction_<T>): Internal.Reference2LongFunction<T>;
        composeFloat(arg0: Internal.Float2LongFunction_): Internal.Float2LongFunction;
        composeLong(arg0: Internal.Long2LongFunction_): this;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        andThenObject<T>(arg0: Internal.Long2ObjectFunction_<T>): Internal.Long2ObjectFunction<T>;
        andThenByte(arg0: Internal.Long2ByteFunction_): Internal.Long2ByteFunction;
        abstract get(arg0: number): number;
        andThenLong(arg0: Internal.Long2LongFunction_): this;
        defaultReturnValue(): number;
        containsKey(arg0: number): boolean;
        compose(arg0: Internal.LongUnaryOperator_): Internal.LongUnaryOperator;
        composeInt(arg0: Internal.Int2LongFunction_): Internal.Int2LongFunction;
        composeDouble(arg0: Internal.Double2LongFunction_): Internal.Double2LongFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        composeShort(arg0: Internal.Short2LongFunction_): Internal.Short2LongFunction;
        applyAsLong(arg0: number): number;
        andThenReference<T>(arg0: Internal.Long2ReferenceFunction_<T>): Internal.Long2ReferenceFunction<T>;
        size(): number;
        apply(arg0: number): number;
        andThenDouble(arg0: Internal.Long2DoubleFunction_): Internal.Long2DoubleFunction;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: number): number;
        clear(): void;
        andThenInt(arg0: Internal.Long2IntFunction_): Internal.Long2IntFunction;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        andThenShort(arg0: Internal.Long2ShortFunction_): Internal.Long2ShortFunction;
        put(arg0: number, arg1: number): number;
        defaultReturnValue(arg0: number): void;
        (arg0: number): number;
    }
    type Long2LongFunction_ = Long2LongFunction;
    interface Condition {
        abstract signalAll(): void;
        abstract await(arg0: number, arg1: Internal.TimeUnit_): boolean;
        abstract signal(): void;
        abstract awaitUninterruptibly(): void;
        abstract await(): void;
        abstract awaitNanos(arg0: number): number;
        abstract awaitUntil(arg0: Internal.Date_): boolean;
    }
    type Condition_ = Condition;
    class TrackObserver extends Internal.SingleBlockEntityEdgePoint {
        constructor()
        setFilterAndNotify(level: Internal.Level_, filter: Internal.ItemStack_): void;
        keepAlive(train: Internal.Train_): void;
        getCurrentTrain(): Internal.UUID;
        getFilter(): Internal.FilterItemStack;
        isActivated(): boolean;
        get currentTrain(): Internal.UUID
        get filter(): Internal.FilterItemStack
        get activated(): boolean
    }
    type TrackObserver_ = TrackObserver;
    class CrystalClusterBlock extends Internal.AmethystClusterBlock {
        constructor(chimeSound: Internal.SoundEvent_, height: number, width: number, props: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type CrystalClusterBlock_ = CrystalClusterBlock;
    class ChatType$BoundNetwork extends Internal.Record {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: number, $$1: net.minecraft.network.chat.Component_, $$2: net.minecraft.network.chat.Component_)
        chatType(): number;
        write($$0: Internal.FriendlyByteBuf_): void;
        resolve($$0: Internal.RegistryAccess_): Internal.Optional<Internal.ChatType$Bound>;
        name(): net.minecraft.network.chat.Component;
        targetName(): net.minecraft.network.chat.Component;
    }
    type ChatType$BoundNetwork_ = ChatType$BoundNetwork;
    interface Object2IntMap$FastEntrySet <K> extends Internal.ObjectSet<Internal.Object2IntMap$Entry<K>> {
        abstract addAll(arg0: Internal.Collection_<Internal.Object2IntMap$Entry<K>>): boolean;
        of<K>(arg0: K, arg1: K, arg2: K): Internal.ObjectSet<K>;
        abstract isEmpty(): boolean;
        of<K>(arg0: K, arg1: K): Internal.ObjectSet<K>;
        abstract add(arg0: Internal.Object2IntMap$Entry_<K>): boolean;
        stream(): Internal.Stream<Internal.Object2IntMap$Entry<K>>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.Set<E>;
        abstract retainAll(arg0: Internal.Collection_<any>): boolean;
        abstract fastIterator(): Internal.ObjectIterator<Internal.Object2IntMap$Entry<K>>;
        abstract containsAll(arg0: Internal.Collection_<any>): boolean;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        parallelStream(): Internal.Stream<Internal.Object2IntMap$Entry<K>>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.Set<E>;
        forEach(arg0: Internal.Consumer_<Internal.Object2IntMap$Entry<K>>): void;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.Set<E>;
        removeIf(arg0: Internal.Predicate_<Internal.Object2IntMap$Entry<K>>): boolean;
        fastForEach(arg0: Internal.Consumer_<Internal.Object2IntMap$Entry<K>>): void;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.Set<E>;
        abstract contains(arg0: any): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.Set<E>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.Set<E>;
        iterator(): Internal.Iterator<any>;
        abstract toArray<T>(arg0: T[]): T[];
        abstract remove(arg0: any): boolean;
        abstract toArray(): any[];
        of<K>(): Internal.ObjectSet<K>;
        abstract size(): number;
        abstract hashCode(): number;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.Set<E>;
        spliterator(): Internal.Spliterator<any>;
        abstract removeAll(arg0: Internal.Collection_<any>): boolean;
        of<K>(...arg0: K[]): Internal.ObjectSet<K>;
        abstract clear(): void;
        of<K>(arg0: K): Internal.ObjectSet<K>;
        abstract equals(arg0: any): boolean;
        copyOf<E>(arg0: Internal.Collection_<E>): Internal.Set<E>;
        get empty(): boolean
    }
    type Object2IntMap$FastEntrySet_<K> = Object2IntMap$FastEntrySet<K>;
    interface Comparator <T> {
        abstract compare(arg0: T, arg1: T): number;
        comparing<T, U extends Internal.Comparable<any>>(arg0: Internal.Function_<T, U>): this;
        reverseOrder<T extends Internal.Comparable<any>>(): this;
        thenComparing<U extends Internal.Comparable<any>>(arg0: Internal.Function_<T, U>): this;
        reversed(): this;
        naturalOrder<T extends Internal.Comparable<any>>(): this;
        thenComparingLong(arg0: Internal.ToLongFunction_<T>): this;
        comparingInt<T>(arg0: Internal.ToIntFunction_<T>): this;
        thenComparingDouble(arg0: Internal.ToDoubleFunction_<T>): this;
        nullsFirst<T>(arg0: Internal.Comparator_<T>): this;
        comparingLong<T>(arg0: Internal.ToLongFunction_<T>): this;
        comparingDouble<T>(arg0: Internal.ToDoubleFunction_<T>): this;
        nullsLast<T>(arg0: Internal.Comparator_<T>): this;
        thenComparing<U>(arg0: Internal.Function_<T, U>, arg1: Internal.Comparator_<U>): this;
        thenComparing(arg0: Internal.Comparator_<T>): this;
        abstract equals(arg0: any): boolean;
        comparing<T, U>(arg0: Internal.Function_<T, U>, arg1: Internal.Comparator_<U>): this;
        thenComparingInt(arg0: Internal.ToIntFunction_<T>): this;
    }
    type Comparator_<T> = Comparator<T>;
    class BookAuthorAttribute$Type implements Internal.ItemAttributeType {
        constructor()
        getAllAttributes(stack: Internal.ItemStack_, level: Internal.Level_): Internal.List<Internal.ItemAttribute>;
        createAttribute(): Internal.ItemAttribute;
    }
    type BookAuthorAttribute$Type_ = BookAuthorAttribute$Type;
    class BufferCapabilities$FlipContents extends Internal.AttributeValue {
        static readonly PRIOR: Internal.BufferCapabilities$FlipContents;
        static readonly COPIED: Internal.BufferCapabilities$FlipContents;
        static readonly BACKGROUND: Internal.BufferCapabilities$FlipContents;
        static readonly UNDEFINED: Internal.BufferCapabilities$FlipContents;
    }
    type BufferCapabilities$FlipContents_ = BufferCapabilities$FlipContents;
    abstract class BearingBlock extends Internal.DirectionalKineticBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        emi(amount: number): Internal.EmiStack;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
    }
    type BearingBlock_ = BearingBlock;
    class DoubleSummaryStatistics implements Internal.DoubleConsumer {
        constructor()
        constructor(arg0: number, arg1: number, arg2: number, arg3: number)
        combine(arg0: Internal.DoubleSummaryStatistics_): void;
        accept(arg0: number): void;
        getSum(): number;
        getCount(): number;
        getAverage(): number;
        andThen(arg0: Internal.DoubleConsumer_): Internal.DoubleConsumer;
        getMin(): number;
        getMax(): number;
        get sum(): number
        get count(): number
        get average(): number
        get min(): number
        get max(): number
    }
    type DoubleSummaryStatistics_ = DoubleSummaryStatistics;
    class PickaxeItem extends Internal.DiggerItem implements Internal.VanillaToolActionItem {
        constructor($$0: Internal.Tier_, $$1: number, $$2: number, $$3: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        port_lib$canPerformAction(stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type PickaxeItem_ = PickaxeItem;
    abstract class BrassDiodeBlockEntity extends Internal.SmartBlockEntity implements Internal.ClipboardCloneable {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        syncComponent(key: Internal.ComponentKey_<any>): void;
        getClipboardKey(): string;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        write(compound: Internal.CompoundTag_, clientPacket: boolean): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        isIdle(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        onLoad(): void;
        writeToClipboard(tag: Internal.CompoundTag_, side: Internal.Direction_): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getProgress(): number;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        readFromClipboard(tag: Internal.CompoundTag_, player: Internal.Player_, side: Internal.Direction_, simulate: boolean): boolean;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        get clipboardKey(): string
        get idle(): boolean
        get progress(): number
        get infiniteBoundingBox(): Internal.AABB
    }
    type BrassDiodeBlockEntity_ = BrassDiodeBlockEntity;
    class NbtKey <T> {
        constructor(key: string, type: any_<T>)
        /**
         * @deprecated
        */
        isIn(nbt: Internal.CompoundTag_): boolean;
        /**
         * @deprecated
        */
        put(nbt: Internal.CompoundTag_, value: T): void;
        /**
         * @deprecated
        */
        get(nbt: Internal.CompoundTag_): T;
        /**
         * @deprecated
        */
        "delete"(nbt: Internal.CompoundTag_): void;
    }
    type NbtKey_<T> = NbtKey<T>;
    interface IPassabilityNavigator {
        abstract isBlockExplicitlyNotPassable(arg0: Internal.BlockState_, arg1: BlockPos_, arg2: BlockPos_): boolean;
        abstract maxSearchNodes(): number;
        abstract isBlockExplicitlyPassable(arg0: Internal.BlockState_, arg1: BlockPos_, arg2: BlockPos_): boolean;
    }
    type IPassabilityNavigator_ = IPassabilityNavigator;
    class CatVariant extends Internal.Record {
        constructor($$0: ResourceLocation_)
        static bootstrap($$0: Internal.Registry_<Internal.CatVariant>): Internal.CatVariant;
        texture(): ResourceLocation;
        static readonly TABBY: Internal.ResourceKey<Internal.CatVariant>;
        static readonly SIAMESE: Internal.ResourceKey<Internal.CatVariant>;
        static readonly RED: Internal.ResourceKey<Internal.CatVariant>;
        static readonly BRITISH_SHORTHAIR: Internal.ResourceKey<Internal.CatVariant>;
        static readonly RAGDOLL: Internal.ResourceKey<Internal.CatVariant>;
        static readonly WHITE: Internal.ResourceKey<Internal.CatVariant>;
        static readonly CALICO: Internal.ResourceKey<Internal.CatVariant>;
        static readonly JELLIE: Internal.ResourceKey<Internal.CatVariant>;
        static readonly PERSIAN: Internal.ResourceKey<Internal.CatVariant>;
        static readonly ALL_BLACK: Internal.ResourceKey<Internal.CatVariant>;
        static readonly BLACK: Internal.ResourceKey<Internal.CatVariant>;
    }
    type CatVariant_ = CatVariant | Special.CatVariant;
    abstract class WrapperMountedFluidStorage <T extends Internal.Storage<Internal.FluidVariant>> extends Internal.MountedFluidStorage {
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateInsert(resource: Internal.FluidVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateExtract(resource: Internal.FluidVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        insert(fluidVariant: Internal.FluidVariant_, l: number, transactionContext: Internal.TransactionContext_): number;
        nonEmptyViews(): Internal.Iterable<Internal.StorageView<Internal.FluidVariant>>;
        forEach(arg0: Internal.Consumer_<Internal.StorageView<T>>): void;
        extract(fluidVariant: Internal.FluidVariant_, l: number, transactionContext: Internal.TransactionContext_): number;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        exactView(resource: Internal.FluidVariant_): Internal.StorageView<Internal.FluidVariant>;
        static empty<T>(): Internal.Storage<T>;
        spliterator(): Internal.Spliterator<Internal.StorageView<T>>;
        iterator(): Internal.Iterator<Internal.StorageView<Internal.FluidVariant>>;
        static asClass<T>(): Internal.Storage<T>;
        nonEmptyIterator(): Internal.Iterator<Internal.StorageView<Internal.FluidVariant>>;
    }
    type WrapperMountedFluidStorage_<T extends Internal.Storage<Internal.FluidVariant>> = WrapperMountedFluidStorage<T>;
    interface AgriGene <T> extends Internal.AgriRegistrable {
        abstract addTooltip(arg0: Internal.List_<net.minecraft.network.chat.Component>, arg1: T): void;
        abstract mutator(): Internal.AgriGeneMutator<T>;
        abstract getRecessiveColor(): number;
        abstract writeToNBT(arg0: Internal.CompoundTag_, arg1: Internal.AgriAllele_<T>, arg2: Internal.AgriAllele_<T>): void;
        abstract getAllele(arg0: T): Internal.AgriAllele<T>;
        abstract defaultAllele(arg0: Internal.AgriPlant_): Internal.AgriAllele<T>;
        abstract readFromNBT(arg0: Internal.CompoundTag_): Internal.AgriGenePair<T>;
        abstract getId(): string;
        abstract getDominantColor(): number;
        get recessiveColor(): number
        get id(): string
        get dominantColor(): number
    }
    type AgriGene_<T> = AgriGene<T>;
    class MemoryCardItem extends Internal.AEBaseItem implements Internal.DyeableLeatherItem, Internal.AEToolItem, Internal.IMemoryCard {
        constructor(properties: Internal.Item$Properties_)
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        getSettingsName(is: Internal.ItemStack_): string;
        notifyUser(player: Internal.Player_, msg: Internal.MemoryCardMessages_): void;
        setDigSpeed(speed: number): void;
        getColorCode(is: Internal.ItemStack_): Internal.AEColor[];
        setAttackSpeed(attackSpeed: number): void;
        getData(is: Internal.ItemStack_): Internal.CompoundTag;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        getCreativeTab(): string;
        static importGenericSettings(importTo: any, input: Internal.CompoundTag_, player: Internal.Player_): Internal.Set<Internal.SettingsCategory>;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        static exportGenericSettings(exportFrom: any, output: Internal.CompoundTag_): Internal.Set<Internal.SettingsCategory>;
        hasCustomColor($$0: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        static dyeArmor($$0: Internal.ItemStack_, $$1: Internal.List_<Internal.DyeItem>): Internal.ItemStack;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        setColor($$0: Internal.ItemStack_, $$1: number): void;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        getColor(stack: Internal.ItemStack_): number;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setMemoryCardContents(is: Internal.ItemStack_, settingsName: string, data: Internal.CompoundTag_): void;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        static importGenericSettingsAndNotify(importTo: any, input: Internal.CompoundTag_, player: Internal.Player_): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        setArmorToughness(armorToughness: number): void;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        static getTintColor(stack: Internal.ItemStack_, tintIndex: number): number;
        emi(amount: number): Internal.EmiStack;
        clearColor($$0: Internal.ItemStack_): void;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        get creativeTab(): string
        set armorKnockbackResistance(knockbackResistance: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
    }
    type MemoryCardItem_ = MemoryCardItem;
    interface ChunkHolder$ChunkLoadingFailure {
        readonly UNLOADED: Internal.ChunkHolder$ChunkLoadingFailure;
    }
    type ChunkHolder$ChunkLoadingFailure_ = ChunkHolder$ChunkLoadingFailure;
    class WeatheringCopperFullBlock extends Internal.Block implements Internal.WeatheringCopper {
        constructor($$0: Internal.WeatheringCopper$WeatherState_, $$1: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        applyChangeOverTime($$0: Internal.BlockState_, $$1: Internal.ServerLevel_, $$2: BlockPos_, $$3: Internal.RandomSource_): void;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        getAge(): Internal.WeatheringCopper$WeatherState;
        getNext($$0: Internal.BlockState_): Internal.Optional<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        static getPrevious($$0: Internal.BlockState_): Internal.Optional<Internal.BlockState>;
        onRandomTick($$0: Internal.BlockState_, $$1: Internal.ServerLevel_, $$2: BlockPos_, $$3: Internal.RandomSource_): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        static getPrevious($$0: Internal.Block_): Internal.Optional<Internal.Block>;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        getAge(): Internal.Enum<any>;
        setDestroySpeed(v: number): void;
        static getFirst($$0: Internal.Block_): Internal.Block;
        static getNext($$0: Internal.Block_): Internal.Optional<Internal.Block>;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        static getFirst($$0: Internal.BlockState_): Internal.BlockState;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        getChanceModifier(): number;
        get blockStates(): Internal.List<Internal.BlockState>
        get age(): Internal.WeatheringCopper$WeatherState
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get age(): Internal.Enum<any>
        set destroySpeed(v: number)
        get chanceModifier(): number
    }
    type WeatheringCopperFullBlock_ = WeatheringCopperFullBlock;
    interface BlockEntityVisual <T extends Internal.BlockEntity> extends Internal.Visual {
        abstract update(arg0: number): void;
        abstract collectCrumblingInstances(arg0: Internal.Consumer_<Internal.Instance>): void;
        abstract "delete"(): void;
    }
    type BlockEntityVisual_<T extends Internal.BlockEntity> = BlockEntityVisual<T>;
    interface IInWorldGridNodeHost {
        abstract getGridNode(arg0: Internal.Direction_): Internal.IGridNode;
        getCableConnectionType(dir: Internal.Direction_): Internal.AECableType;
        (arg0: Internal.Direction): Internal.IGridNode_;
        readonly LOOKUP: Internal.BlockApiLookup<Internal.IInWorldGridNodeHost, void>;
    }
    type IInWorldGridNodeHost_ = IInWorldGridNodeHost;
    class EmiTexture implements Internal.EmiRenderable {
        constructor(texture: ResourceLocation_, u: number, v: number, width: number, height: number)
        constructor(texture: ResourceLocation_, u: number, v: number, width: number, height: number, regionWidth: number, regionHeight: number, textureWidth: number, textureHeight: number)
        render(draw: Internal.GuiGraphics_, x: number, y: number, delta: number): void;
        readonly width: number;
        readonly textureHeight: number;
        static readonly PLUS: Internal.EmiTexture;
        readonly textureWidth: number;
        static readonly FULL_FLAME: Internal.EmiTexture;
        readonly regionHeight: number;
        readonly regionWidth: number;
        static readonly FULL_ARROW: Internal.EmiTexture;
        static readonly SLOT: Internal.EmiTexture;
        readonly height: number;
        static readonly SHAPELESS: Internal.EmiTexture;
        readonly v: number;
        readonly texture: ResourceLocation;
        static readonly LARGE_SLOT: Internal.EmiTexture;
        readonly u: number;
        static readonly EMPTY_ARROW: Internal.EmiTexture;
        static readonly EMPTY_FLAME: Internal.EmiTexture;
    }
    type EmiTexture_ = EmiTexture;
    class InterfaceAddress {
        getNetworkPrefixLength(): number;
        getAddress(): Internal.InetAddress;
        getBroadcast(): Internal.InetAddress;
        get networkPrefixLength(): number
        get address(): Internal.InetAddress
        get broadcast(): Internal.InetAddress
    }
    type InterfaceAddress_ = InterfaceAddress;
    class ResourceKeyArgument <T> implements Internal.ArgumentType<Internal.ResourceKey<T>> {
        constructor($$0: Internal.ResourceKey_<Internal.Registry<T>>)
        static getConfiguredFeature($$0: Internal.CommandContext_<Internal.CommandSourceStack>, $$1: string): Internal.Holder$Reference<Internal.ConfiguredFeature<any, any>>;
        getExamples(): Internal.Collection<string>;
        static getStructureTemplatePool($$0: Internal.CommandContext_<Internal.CommandSourceStack>, $$1: string): Internal.Holder$Reference<Internal.StructureTemplatePool>;
        listSuggestions<S>($$0: Internal.CommandContext_<S>, $$1: Internal.SuggestionsBuilder_): Internal.CompletableFuture<Internal.Suggestions>;
        static getStructure($$0: Internal.CommandContext_<Internal.CommandSourceStack>, $$1: string): Internal.Holder$Reference<Internal.Structure>;
        parse($$0: Internal.StringReader_): Internal.ResourceKey<T>;
        parse(arg0: Internal.StringReader_): any;
        static key<T>($$0: Internal.ResourceKey_<Internal.Registry<T>>): Internal.ResourceKeyArgument<T>;
        get examples(): Internal.Collection<string>
    }
    type ResourceKeyArgument_<T> = ResourceKeyArgument<T>;
    class AnomalyBlock$AnomalyType extends Internal.Enum<Internal.AnomalyBlock$AnomalyType> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static values(): Internal.AnomalyBlock$AnomalyType[];
        getSerializedName(): string;
        static valueOf(name: string): Internal.AnomalyBlock$AnomalyType;
        get serializedName(): string
        static readonly UNSTABLE: Internal.AnomalyBlock$AnomalyType;
        static readonly VOLATILE: Internal.AnomalyBlock$AnomalyType;
        static readonly QUIRKY: Internal.AnomalyBlock$AnomalyType;
        static readonly STABLE: Internal.AnomalyBlock$AnomalyType;
    }
    type AnomalyBlock$AnomalyType_ = "unstable" | "quirky" | AnomalyBlock$AnomalyType | "volatile" | "stable";
    class NoGravMagicalDohickyItem extends Internal.Item implements Internal.EntityTickListenerItem {
        constructor(p_i48487_1_: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        onEntityItemUpdate(stack: Internal.ItemStack_, entity: Internal.ItemEntity_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type NoGravMagicalDohickyItem_ = NoGravMagicalDohickyItem;
    class ListSetArithmetic implements Internal.Arithmetic {
        getOperator(pattern: Internal.HexPattern_): Internal.Operator;
        opTypes(): Internal.List<Internal.HexPattern>;
        arithName(): string;
        static readonly INSTANCE: Internal.ListSetArithmetic;
    }
    type ListSetArithmetic_ = ListSetArithmetic;
    class ServerboundBlockEntityTagQuery implements Internal.Packet<Internal.ServerGamePacketListener> {
        constructor($$0: number, $$1: BlockPos_)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        getPos(): BlockPos;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ServerGamePacketListener_): void;
        getTransactionId(): number;
        isSkippable(): boolean;
        get pos(): BlockPos
        get transactionId(): number
        get skippable(): boolean
    }
    type ServerboundBlockEntityTagQuery_ = ServerboundBlockEntityTagQuery;
    class AreaSelectorItem extends Internal.Item {
        constructor(settings: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        static getLookTarget(player: Internal.Player_): BlockPos;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        static setArea(stack: Internal.ItemStack_, area: Internal.AreaSelection_): void;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        static getArea(stack: Internal.ItemStack_): Internal.AreaSelection;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly TO_RESET: Internal.MutableComponent;
        static readonly SUCCESS_SECOND: Internal.MutableComponent;
        static readonly RESET: Internal.MutableComponent;
        static readonly REQUIRES_OP: Internal.MutableComponent;
        static readonly AREA_KEY: "area";
        static readonly SUCCESS_FIRST: Internal.MutableComponent;
    }
    type AreaSelectorItem_ = AreaSelectorItem;
    class NoteBlock extends Internal.Block {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        static getPitchFromNote($$0: number): number;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly NOTE_VOLUME: 3;
        static readonly INSTRUMENT: Internal.EnumProperty<Internal.NoteBlockInstrument>;
        static readonly NOTE: Internal.IntegerProperty;
        static readonly POWERED: Internal.BooleanProperty;
    }
    type NoteBlock_ = NoteBlock;
    abstract class ValueBoxTransform {
        constructor()
        transform(level: Internal.LevelAccessor_, pos: BlockPos_, state: Internal.BlockState_, ms: Internal.PoseStack_): void;
        getFontScale(): number;
        abstract getLocalOffset(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): Vec3d;
        getOverrideColor(): number;
        testHit(level: Internal.LevelAccessor_, pos: BlockPos_, state: Internal.BlockState_, localHit: Vec3d_): boolean;
        abstract rotate(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.PoseStack_): void;
        shouldRender(level: Internal.LevelAccessor_, pos: BlockPos_, state: Internal.BlockState_): boolean;
        getScale(): number;
        get fontScale(): number
        get overrideColor(): number
        get scale(): number
    }
    type ValueBoxTransform_ = ValueBoxTransform;
    class PoweredRailBlock extends Internal.BaseRailBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly SHAPE: Internal.EnumProperty<Internal.RailShape>;
        static readonly POWERED: Internal.BooleanProperty;
    }
    type PoweredRailBlock_ = PoweredRailBlock;
    class StreamTagVisitor$ValueResult extends Internal.Enum<Internal.StreamTagVisitor$ValueResult> {
        static values(): Internal.StreamTagVisitor$ValueResult[];
        static valueOf($$0: string): Internal.StreamTagVisitor$ValueResult;
        static readonly CONTINUE: Internal.StreamTagVisitor$ValueResult;
        static readonly BREAK: Internal.StreamTagVisitor$ValueResult;
        static readonly HALT: Internal.StreamTagVisitor$ValueResult;
    }
    type StreamTagVisitor$ValueResult_ = "break" | "halt" | StreamTagVisitor$ValueResult | "continue";
    class ModelBuilder$TransformsBuilder$TransformVecBuilder {
        end(): Internal.ModelBuilder$TransformsBuilder<>;
        leftRotation(x: number, y: number, z: number): this;
        translation(x: number, y: number, z: number): this;
        scale(sc: number): this;
        scale(x: number, y: number, z: number): this;
        rightRotation(x: number, y: number, z: number): this;
        rotation(x: number, y: number, z: number): this;
    }
    type ModelBuilder$TransformsBuilder$TransformVecBuilder_ = ModelBuilder$TransformsBuilder$TransformVecBuilder;
    interface Int2ReferenceFunction <V> extends Internal.IntFunction<V>, it.unimi.dsi.fastutil.Function<number, V> {
        andThenShort(arg0: Internal.Reference2ShortFunction_<V>): Internal.Int2ShortFunction;
        andThenChar(arg0: Internal.Reference2CharFunction_<V>): Internal.Int2CharFunction;
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<number, V>;
        put(arg0: number, arg1: V): V;
        composeInt(arg0: Internal.Int2IntFunction_): this;
        composeChar(arg0: Internal.Char2IntFunction_): Internal.Char2ReferenceFunction<V>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: V): V;
        composeShort(arg0: Internal.Short2IntFunction_): Internal.Short2ReferenceFunction<V>;
        composeLong(arg0: Internal.Long2IntFunction_): Internal.Long2ReferenceFunction<V>;
        containsKey(arg0: number): boolean;
        andThenObject<T>(arg0: Internal.Reference2ObjectFunction_<V, T>): Internal.Int2ObjectFunction<T>;
        andThenDouble(arg0: Internal.Reference2DoubleFunction_<V>): Internal.Int2DoubleFunction;
        andThenByte(arg0: Internal.Reference2ByteFunction_<V>): Internal.Int2ByteFunction;
        andThenReference<T>(arg0: Internal.Reference2ReferenceFunction_<V, T>): Internal.Int2ReferenceFunction<T>;
        abstract get(arg0: number): V;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: V): V;
        composeReference<T>(arg0: Internal.Reference2IntFunction_<T>): Internal.Reference2ReferenceFunction<T, V>;
        andThenLong(arg0: Internal.Reference2LongFunction_<V>): Internal.Int2LongFunction;
        composeDouble(arg0: Internal.Double2IntFunction_): Internal.Double2ReferenceFunction<V>;
        /**
         * @deprecated
        */
        get(arg0: any): V;
        apply(arg0: number): V;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        apply(arg0: number): V;
        /**
         * @deprecated
        */
        remove(arg0: any): V;
        composeObject<T>(arg0: Internal.Object2IntFunction_<T>): Internal.Object2ReferenceFunction<T, V>;
        andThenInt(arg0: Internal.Reference2IntFunction_<V>): Internal.Int2IntFunction;
        remove(arg0: number): V;
        getOrDefault(arg0: number, arg1: V): V;
        andThenFloat(arg0: Internal.Reference2FloatFunction_<V>): Internal.Int2FloatFunction;
        size(): number;
        composeByte(arg0: Internal.Byte2IntFunction_): Internal.Byte2ReferenceFunction<V>;
        composeFloat(arg0: Internal.Float2IntFunction_): Internal.Float2ReferenceFunction<V>;
        clear(): void;
        defaultReturnValue(): V;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, V>;
        identity<T>(): Internal.Function<T, T>;
        defaultReturnValue(arg0: V): void;
        (arg0: number): V;
    }
    type Int2ReferenceFunction_<V> = Int2ReferenceFunction<V>;
    interface DispensibleContainerItem {
        abstract emptyContents(arg0: Internal.Player_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockHitResult_): boolean;
        checkExtraContent($$0: Internal.Player_, $$1: Internal.Level_, $$2: Internal.ItemStack_, $$3: BlockPos_): void;
        (arg0: Internal.Player, arg1: Internal.Level, arg2: BlockPos, arg3: Internal.BlockHitResult): boolean;
    }
    type DispensibleContainerItem_ = DispensibleContainerItem;
    class ChunkMap extends Internal.ChunkStorage implements Internal.ThreadedAnvilChunkStorageAccessor, Internal.ChunkHolder$PlayerProvider {
        constructor($$0: Internal.ServerLevel_, $$1: Internal.LevelStorageSource$LevelStorageAccess_, $$2: Internal.DataFixer_, $$3: Internal.StructureTemplateManager_, $$4: Internal.Executor_, $$5: Internal.BlockableEventLoop_<Internal.Runnable>, $$6: Internal.LightChunkGetter_, $$7: Internal.ChunkGenerator_, $$8: Internal.ChunkProgressListener_, $$9: any_, $$10: Internal.Supplier_<Internal.DimensionDataStorage>, $$11: number, $$12: boolean)
        getChunkQueueLevel($$0: number): Internal.IntSupplier;
        broadcast($$0: Internal.Entity_, $$1: Internal.Packet_<any>): void;
        static isChunkInRange($$0: number, $$1: number, $$2: number, $$3: number, $$4: number): boolean;
        releaseLightTicket($$0: Internal.ChunkPos_): void;
        getStorageName(): string;
        prepareAccessibleChunk($$0: Internal.ChunkHolder_): Internal.CompletableFuture<Internal.Either<Internal.LevelChunk, Internal.ChunkHolder$ChunkLoadingFailure>>;
        getEntityTrackers(): Internal.Int2ObjectMap<any>;
        getPlayers($$0: Internal.ChunkPos_, $$1: boolean): Internal.List<Internal.ServerPlayer>;
        getTickingGenerated(): number;
        resendBiomesForChunks($$0: Internal.List_<Internal.ChunkAccess>): void;
        getVisibleChunkIfPresent($$0: number): Internal.ChunkHolder;
        prepareTickingChunk($$0: Internal.ChunkHolder_): Internal.CompletableFuture<Internal.Either<Internal.LevelChunk, Internal.ChunkHolder$ChunkLoadingFailure>>;
        debugReloadGenerator(): void;
        getDistanceManager(): Internal.DistanceManager;
        handler$zbb000$porting_lib_base$port_lib$startTrackingChunk(player: Internal.ServerPlayer_, chunkPos: Internal.ChunkPos_, packetCache: Internal.MutableObject_<any>, wasLoaded: boolean, load: boolean, ci: Internal.CallbackInfo_): void;
        move(player: Internal.ServerPlayer_): void;
        size(): number;
        schedule($$0: Internal.ChunkHolder_, $$1: Internal.ChunkStatus_): Internal.CompletableFuture<Internal.Either<Internal.ChunkAccess, Internal.ChunkHolder$ChunkLoadingFailure>>;
        getUpdatingChunkIfPresent($$0: number): Internal.ChunkHolder;
        prepareEntityTickingChunk($$0: Internal.ChunkHolder_): Internal.CompletableFuture<Internal.Either<Internal.LevelChunk, Internal.ChunkHolder$ChunkLoadingFailure>>;
        debugFuturesAndCreateReportedException($$0: Internal.IllegalStateException_, $$1: string): Internal.ReportedException;
        getPlayersCloseForSpawning($$0: Internal.ChunkPos_): Internal.List<Internal.ServerPlayer>;
        hasWork(): boolean;
        getChunkDebugData($$0: Internal.ChunkPos_): string;
        get storageName(): string
        get entityTrackers(): Internal.Int2ObjectMap<any>
        get tickingGenerated(): number
        get distanceManager(): Internal.DistanceManager
        readonly updatingChunkMap: Internal.Long2ObjectLinkedOpenHashMap<Internal.ChunkHolder>;
        static readonly FORCED_TICKET_LEVEL: 31;
        readonly pendingUnloads: Internal.Long2ObjectLinkedOpenHashMap<Internal.ChunkHolder>;
        readonly mainThreadExecutor: Internal.BlockableEventLoop<Internal.Runnable>;
        static readonly MAX_VIEW_DISTANCE: 32;
        readonly entityMap: Internal.Int2ObjectMap<Internal.ChunkMap$TrackedEntity>;
        visibleChunkMap: Internal.Long2ObjectLinkedOpenHashMap<Internal.ChunkHolder>;
        readonly level: Internal.ServerLevel;
    }
    type ChunkMap_ = ChunkMap;
    interface ClientLevelExtensions {
        port_lib$invalidateCache(pos: BlockPos_): void;
        port_lib$registerCache(pos: BlockPos_, cache: Internal.ClientBlockApiCache_): void;
    }
    type ClientLevelExtensions_ = ClientLevelExtensions;
    class SimpleRegistryImpl$SingleImpl <K, V> extends Internal.SimpleRegistryImpl<K, V> {
        static create<K, V>(): Internal.SimpleRegistry<K, V>;
        get(object: K): V;
    }
    type SimpleRegistryImpl$SingleImpl_<K, V> = SimpleRegistryImpl$SingleImpl<K, V>;
    class ClientboundChunksBiomesPacket extends Internal.Record implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.List_<Internal.ClientboundChunksBiomesPacket$ChunkBiomeData>)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        chunkBiomeData(): Internal.List<Internal.ClientboundChunksBiomesPacket$ChunkBiomeData>;
        handle($$0: Internal.ClientGamePacketListener_): void;
        static forChunks($$0: Internal.List_<Internal.LevelChunk>): Internal.ClientboundChunksBiomesPacket;
        isSkippable(): boolean;
        get skippable(): boolean
    }
    type ClientboundChunksBiomesPacket_ = ClientboundChunksBiomesPacket;
    class StockTickerBlock extends Internal.HorizontalDirectionalBlock implements com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.IBE<Internal.StockTickerBlockEntity> {
        constructor(pProperties: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.StockTickerBlockEntity>): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        getBlockEntityClass(): typeof Internal.StockTickerBlockEntity;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getBlockEntityType(): Internal.BlockEntityType<Internal.StockTickerBlockEntity>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        getHat(level: Internal.LevelAccessor_, pos: BlockPos_, keeper: Internal.LivingEntity_): Internal.PartialModel;
        setLightEmission(v: number): void;
        getMod(): string;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.StockTickerBlockEntity;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.StockTickerBlockEntity>;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.StockTickerBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        get blockEntityClass(): typeof Internal.StockTickerBlockEntity
        get blockStates(): Internal.List<Internal.BlockState>
        get blockEntityType(): Internal.BlockEntityType<Internal.StockTickerBlockEntity>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type StockTickerBlock_ = StockTickerBlock;
    class MilkBottleItem extends Internal.DrinkableItem {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type MilkBottleItem_ = MilkBottleItem;
    interface OwoScreenExtension {
        abstract owo$getInstance<S extends Internal.Screen, R extends Internal.ParentComponent>(arg0: Internal.Layer_<S, R>): Internal.Layer$Instance<>;
        abstract owo$getInstancesView(): Internal.List<Internal.Layer$Instance<>>;
        abstract owo$updateLayers(): void;
    }
    type OwoScreenExtension_ = OwoScreenExtension;
    interface GameRulesKJS {
        abstract kjs$set(arg0: string, arg1: string): void;
        kjs$getBoolean(rule: string): boolean;
        kjs$getInt(rule: string): number;
        kjs$getString(rule: string): string;
        abstract kjs$get(arg0: string): Internal.GameRules$Value<any>;
    }
    type GameRulesKJS_ = GameRulesKJS;
    interface ItemVariantCache {
        abstract fabric_getCachedItemVariant(): Internal.ItemVariant;
        (): Internal.ItemVariant_;
    }
    type ItemVariantCache_ = ItemVariantCache;
    class SpectatorGui implements Internal.SpectatorMenuListener {
        constructor($$0: Internal.Minecraft_)
        isMenuActive(): boolean;
        renderTooltip($$0: Internal.GuiGraphics_): void;
        onHotbarSelected($$0: number): void;
        onMouseScrolled($$0: number): void;
        onMouseMiddleClick(): void;
        onSpectatorMenuClosed($$0: Internal.SpectatorMenu_): void;
        renderHotbar($$0: Internal.GuiGraphics_): void;
        get menuActive(): boolean
        static readonly SPECTATOR_LOCATION: ResourceLocation;
    }
    type SpectatorGui_ = SpectatorGui;
    interface SpriteSet {
        abstract get(arg0: number, arg1: number): Internal.TextureAtlasSprite;
        abstract get(arg0: Internal.RandomSource_): Internal.TextureAtlasSprite;
    }
    type SpriteSet_ = SpriteSet;
    class GenericStackInv implements Internal.MEStorage, Internal.GenericInternalInventory {
        constructor(listener: Internal.Runnable_, mode: Internal.GenericStackInv$Mode_, size: number)
        constructor(listener: Internal.Runnable_, size: number)
        canInsert(): boolean;
        useRegisteredCapacities(): void;
        insert(slot: number, what: Internal.AEKey_, amount: number, mode: Internal.Actionable_): number;
        extract(what: Internal.AEKey_, amount: number, mode: Internal.Actionable_, source: Internal.IActionSource_): number;
        getFilter(): Internal.AEKeyFilter;
        beginBatch(): void;
        endBatchSuppressed(): void;
        isEmpty(): boolean;
        isAllowed(stack: Internal.GenericStack_): boolean;
        endBatch(): void;
        onChange(): void;
        static checkPreconditions(what: Internal.AEKey_, amount: number, mode: Internal.Actionable_, source: Internal.IActionSource_): void;
        getMaxAmount(key: Internal.AEKey_): number;
        writeToChildTag(tag: Internal.CompoundTag_, name: string): void;
        createMenuWrapper(): Internal.ConfigMenuInventory;
        readFromTag(tag: Internal.ListTag_): void;
        getAmount(slot: number): number;
        setDescription(description: net.minecraft.network.chat.Component_): void;
        setCapacity(space: Internal.AEKeyType_, capacity: number): void;
        readFromChildTag(tag: Internal.CompoundTag_, name: string): void;
        isAllowed(what: Internal.AEKey_): boolean;
        getMode(): Internal.GenericStackInv$Mode;
        isPreferredStorageFor(what: Internal.AEKey_, source: Internal.IActionSource_): boolean;
        setStack(slot: number, stack: Internal.GenericStack_): void;
        getAvailableStacks(): Internal.KeyCounter;
        getKey(slot: number): Internal.AEKey;
        getCapacity(space: Internal.AEKeyType_): number;
        writeToTag(): Internal.ListTag;
        getAvailableStacks(out: Internal.KeyCounter_): void;
        size(): number;
        canExtract(): boolean;
        clear(): void;
        insert(what: Internal.AEKey_, amount: number, mode: Internal.Actionable_, source: Internal.IActionSource_): number;
        updateSnapshots(slot: number, transaction: Internal.TransactionContext_): void;
        getStack(slot: number): Internal.GenericStack;
        extract(slot: number, what: Internal.AEKey_, amount: number, mode: Internal.Actionable_): number;
        getDescription(): net.minecraft.network.chat.Component;
        get filter(): Internal.AEKeyFilter
        get empty(): boolean
        set description(description: net.minecraft.network.chat.Component_)
        get mode(): Internal.GenericStackInv$Mode
        get availableStacks(): Internal.KeyCounter
        get description(): net.minecraft.network.chat.Component
    }
    type GenericStackInv_ = GenericStackInv;
    class Window extends Internal.Container implements Internal.Accessible {
        constructor(arg0: Internal.Window_)
        constructor(arg0: Internal.Window_, arg1: Internal.GraphicsConfiguration_)
        constructor(arg0: Internal.Frame_)
        getModalExclusionType(): Internal.Dialog$ModalExclusionType;
        /**
         * @deprecated
        */
        applyResourceBundle(arg0: Internal.ResourceBundle_): void;
        setOpacity(arg0: number): void;
        getOwnedWindows(): Internal.Window[];
        toBack(): void;
        removeWindowListener(arg0: Internal.WindowListener_): void;
        static getOwnerlessWindows(): Internal.Window[];
        getFocusOwner(): Internal.Component;
        addWindowFocusListener(arg0: Internal.WindowFocusListener_): void;
        isAlwaysOnTopSupported(): boolean;
        getOpacity(): number;
        removeWindowFocusListener(arg0: Internal.WindowFocusListener_): void;
        getWindowStateListeners(): Internal.WindowStateListener[];
        setType(arg0: Internal.Window$Type_): void;
        setAlwaysOnTop(arg0: boolean): void;
        setIconImages(arg0: Internal.List_<Internal.Image>): void;
        getWindowListeners(): Internal.WindowListener[];
        createBufferStrategy(arg0: number, arg1: Internal.BufferCapabilities_): void;
        getIconImages(): Internal.List<Internal.Image>;
        isLocationByPlatform(): boolean;
        getShape(): Internal.Shape;
        toFront(): void;
        getWindowFocusListeners(): Internal.WindowFocusListener[];
        getFocusableWindowState(): boolean;
        setLocationRelativeTo(arg0: Internal.Component_): void;
        dispose(): void;
        getOwner(): this;
        static getWindows(): Internal.Window[];
        isFocusableWindow(): boolean;
        isFocused(): boolean;
        isAutoRequestFocus(): boolean;
        isAlwaysOnTop(): boolean;
        isActive(): boolean;
        getListeners<T extends Internal.EventListener>(arg0: T): T[];
        getWarningString(): string;
        setLocationByPlatform(arg0: boolean): void;
        setFocusableWindowState(arg0: boolean): void;
        addWindowListener(arg0: Internal.WindowListener_): void;
        pack(): void;
        createBufferStrategy(arg0: number): void;
        getMostRecentFocusOwner(): Internal.Component;
        setModalExclusionType(arg0: Internal.Dialog$ModalExclusionType_): void;
        setShape(arg0: Internal.Shape_): void;
        setIconImage(arg0: Internal.Image_): void;
        setAutoRequestFocus(arg0: boolean): void;
        getType(): Internal.Window$Type;
        /**
         * @deprecated
        */
        applyResourceBundle(arg0: string): void;
        getBufferStrategy(): Internal.BufferStrategy;
        addWindowStateListener(arg0: Internal.WindowStateListener_): void;
        removeWindowStateListener(arg0: Internal.WindowStateListener_): void;
        get modalExclusionType(): Internal.Dialog$ModalExclusionType
        set opacity(arg0: number)
        get ownedWindows(): Internal.Window[]
        get ownerlessWindows(): Internal.Window[]
        get focusOwner(): Internal.Component
        get alwaysOnTopSupported(): boolean
        get opacity(): number
        get windowStateListeners(): Internal.WindowStateListener[]
        set type(arg0: Internal.Window$Type_)
        set alwaysOnTop(arg0: boolean)
        set iconImages(arg0: Internal.List_<Internal.Image>)
        get windowListeners(): Internal.WindowListener[]
        get iconImages(): Internal.List<Internal.Image>
        get locationByPlatform(): boolean
        get shape(): Internal.Shape
        get windowFocusListeners(): Internal.WindowFocusListener[]
        get focusableWindowState(): boolean
        set locationRelativeTo(arg0: Internal.Component_)
        get owner(): Internal.Window
        get windows(): Internal.Window[]
        get focusableWindow(): boolean
        get focused(): boolean
        get autoRequestFocus(): boolean
        get alwaysOnTop(): boolean
        get active(): boolean
        get warningString(): string
        set locationByPlatform(arg0: boolean)
        set focusableWindowState(arg0: boolean)
        get mostRecentFocusOwner(): Internal.Component
        set modalExclusionType(arg0: Internal.Dialog$ModalExclusionType_)
        set shape(arg0: Internal.Shape_)
        set iconImage(arg0: Internal.Image_)
        set autoRequestFocus(arg0: boolean)
        get type(): Internal.Window$Type
        get bufferStrategy(): Internal.BufferStrategy
    }
    type Window_ = Window;
    interface ExtensionHolder {
        abstract getExtension<T>(arg0: any, arg1: T): T;
        abstract setExtension(arg0: any, arg1: any): void;
    }
    type ExtensionHolder_ = ExtensionHolder;
    class ChiseledBookShelfBlock extends Internal.BaseEntityBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        static getHitSlot($$0: Internal.Vec2_): number;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        static getRelativeHitCoordinatesForBlockFace($$0: Internal.BlockHitResult_, $$1: Internal.Direction_): Internal.Optional<Internal.Vec2>;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly SLOT_OCCUPIED_PROPERTIES: [Internal.BooleanProperty, Internal.BooleanProperty, Internal.BooleanProperty, Internal.BooleanProperty, Internal.BooleanProperty, Internal.BooleanProperty];
        static readonly BOOKS_PER_ROW: 3;
    }
    type ChiseledBookShelfBlock_ = ChiseledBookShelfBlock;
    class ItemModelShaper {
        constructor($$0: Internal.ModelManager_)
        "handler$cja000$fabric-registry-sync-v0$onInit"(bakedModelManager: Internal.ModelManager_, info: Internal.CallbackInfo_): void;
        getItemModel($$0: Internal.ItemStack_): Internal.BakedModel;
        getModelManager(): Internal.ModelManager;
        register($$0: Internal.Item_, $$1: Internal.ModelResourceLocation_): void;
        rebuildCache(): void;
        getItemModel($$0: Internal.Item_): Internal.BakedModel;
        get modelManager(): Internal.ModelManager
        readonly shapes: Internal.Int2ObjectMap<Internal.ModelResourceLocation>;
    }
    type ItemModelShaper_ = ItemModelShaper;
    class LevelStorageSource$LevelDirectory extends Internal.Record {
        constructor($$0: Internal.Path_)
        resourcePath($$0: Internal.LevelResource_): Internal.Path;
        directoryName(): string;
        iconFile(): Internal.Path;
        lockFile(): Internal.Path;
        dataFile(): Internal.Path;
        path(): Internal.Path;
        corruptedDataFile($$0: Internal.LocalDateTime_): Internal.Path;
        oldDataFile(): Internal.Path;
    }
    type LevelStorageSource$LevelDirectory_ = LevelStorageSource$LevelDirectory;
    interface ExtendedChunk {
        abstract getBlockEmptinessMap(): boolean[];
        abstract setSkyNibbles(arg0: any_[]): void;
        abstract setBlockEmptinessMap(arg0: boolean[]): void;
        abstract getSkyNibbles(): any[];
        abstract setSkyEmptinessMap(arg0: boolean[]): void;
        abstract getSkyEmptinessMap(): boolean[];
        abstract setBlockNibbles(arg0: any_[]): void;
        abstract getBlockNibbles(): any[];
        get blockEmptinessMap(): boolean[]
        set skyNibbles(arg0: any_[])
        set blockEmptinessMap(arg0: boolean[])
        get skyNibbles(): any[]
        set skyEmptinessMap(arg0: boolean[])
        get skyEmptinessMap(): boolean[]
        set blockNibbles(arg0: any_[])
        get blockNibbles(): any[]
    }
    type ExtendedChunk_ = ExtendedChunk;
    class File implements Internal.Comparable<Internal.File>, Internal.Serializable {
        constructor(arg0: string, arg1: string)
        constructor(arg0: string)
        constructor(arg0: Internal.URI_)
        constructor(arg0: Internal.File_, arg1: string)
        canWrite(): boolean;
        getAbsolutePath(): string;
        getCanonicalFile(): this;
        getParent(): string;
        /**
         * @deprecated
        */
        toURL(): Internal.URL;
        "delete"(): boolean;
        listFiles(arg0: Internal.FileFilter_): Internal.File[];
        setWritable(arg0: boolean, arg1: boolean): boolean;
        static createTempFile(arg0: string, arg1: string): Internal.File;
        isDirectory(): boolean;
        compareTo(arg0: any): number;
        getParentFile(): this;
        setLastModified(arg0: number): boolean;
        setReadable(arg0: boolean): boolean;
        getName(): string;
        listFiles(): Internal.File[];
        getUsableSpace(): number;
        toPath(): Internal.Path;
        list(arg0: Internal.FilenameFilter_): string[];
        mkdir(): boolean;
        setWritable(arg0: boolean): boolean;
        compareTo(arg0: Internal.File_): number;
        isFile(): boolean;
        getPath(): string;
        createNewFile(): boolean;
        lastModified(): number;
        length(): number;
        setExecutable(arg0: boolean, arg1: boolean): boolean;
        getFreeSpace(): number;
        isHidden(): boolean;
        deleteOnExit(): void;
        setReadOnly(): boolean;
        setReadable(arg0: boolean, arg1: boolean): boolean;
        mkdirs(): boolean;
        renameTo(arg0: Internal.File_): boolean;
        getCanonicalPath(): string;
        setExecutable(arg0: boolean): boolean;
        static listRoots(): Internal.File[];
        listFiles(arg0: Internal.FilenameFilter_): Internal.File[];
        canRead(): boolean;
        exists(): boolean;
        static createTempFile(arg0: string, arg1: string, arg2: Internal.File_): Internal.File;
        list(): string[];
        toURI(): Internal.URI;
        getAbsoluteFile(): this;
        canExecute(): boolean;
        getTotalSpace(): number;
        isAbsolute(): boolean;
        get absolutePath(): string
        get canonicalFile(): Internal.File
        get parent(): string
        get directory(): boolean
        get parentFile(): Internal.File
        set lastModified(arg0: number)
        set readable(arg0: boolean)
        get name(): string
        get usableSpace(): number
        set writable(arg0: boolean)
        get file(): boolean
        get path(): string
        get freeSpace(): number
        get hidden(): boolean
        get canonicalPath(): string
        set executable(arg0: boolean)
        get absoluteFile(): Internal.File
        get totalSpace(): number
        get absolute(): boolean
        static readonly separator: "\\";
        static readonly separatorChar: "\\";
        static readonly pathSeparatorChar: ";";
        static readonly pathSeparator: ";";
    }
    type File_ = File;
    interface ScreenHandlerInvoker {
        abstract owo$insertItem(arg0: Internal.ItemStack_, arg1: number, arg2: number, arg3: boolean): boolean;
        (arg0: Internal.ItemStack, arg1: number, arg2: number, arg3: boolean): boolean;
    }
    type ScreenHandlerInvoker_ = ScreenHandlerInvoker;
    class DragonFrostParticleType extends Internal.DragonParticleType<Internal.DragonFrostParticleType> {
        constructor()
        constructor(scale: number)
        codec(): Internal.Codec<Internal.DragonFrostParticleType>;
    }
    type DragonFrostParticleType_ = DragonFrostParticleType;
    class LargeBogeyBlock extends Internal.CRBogeyBlock {
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.CRBogeyBlockEntity;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.CRBogeyBlockEntity>;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.CRBogeyBlockEntity>): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.CRBogeyBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type LargeBogeyBlock_ = LargeBogeyBlock;
    class ModelBuilder$ElementBuilder$RotationBuilder {
        constructor(this$1: Internal.ModelBuilder$ElementBuilder_)
        end(): Internal.ModelBuilder$ElementBuilder<>;
        angle(angle: number): this;
        origin(x: number, y: number, z: number): this;
        rescale(rescale: boolean): this;
        axis(axis: Internal.Direction$Axis_): this;
    }
    type ModelBuilder$ElementBuilder$RotationBuilder_ = ModelBuilder$ElementBuilder$RotationBuilder;
    interface DispenseItemBehavior {
        bootStrap(): void;
        abstract dispense(arg0: Internal.BlockSource_, arg1: Internal.ItemStack_): Internal.ItemStack;
        setEntityPokingOutOfBlock($$0: Internal.BlockSource_, $$1: Internal.Entity_, $$2: Internal.Direction_): void;
        (arg0: Internal.BlockSource, arg1: Internal.ItemStack): Internal.ItemStack_;
        readonly LOGGER: Internal.Log4jLogger;
        readonly NOOP: Internal.DispenseItemBehavior;
    }
    type DispenseItemBehavior_ = DispenseItemBehavior;
    class SchematicPrinter$PrintStage extends Internal.Enum<Internal.SchematicPrinter$PrintStage> {
        static values(): Internal.SchematicPrinter$PrintStage[];
        static valueOf(name: string): Internal.SchematicPrinter$PrintStage;
        static readonly ENTITIES: Internal.SchematicPrinter$PrintStage;
        static readonly BLOCKS: Internal.SchematicPrinter$PrintStage;
        static readonly DEFERRED_BLOCKS: Internal.SchematicPrinter$PrintStage;
    }
    type SchematicPrinter$PrintStage_ = SchematicPrinter$PrintStage | "deferred_blocks" | "entities" | "blocks";
    class ServerboundLockDifficultyPacket implements Internal.Packet<Internal.ServerGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: boolean)
        handle(arg0: Internal.PacketListener_): void;
        isLocked(): boolean;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ServerGamePacketListener_): void;
        isSkippable(): boolean;
        get locked(): boolean
        get skippable(): boolean
    }
    type ServerboundLockDifficultyPacket_ = ServerboundLockDifficultyPacket;
    class ServerboundPlayerActionPacket$Action extends Internal.Enum<Internal.ServerboundPlayerActionPacket$Action> {
        static values(): Internal.ServerboundPlayerActionPacket$Action[];
        static valueOf($$0: string): Internal.ServerboundPlayerActionPacket$Action;
        static readonly DROP_ITEM: Internal.ServerboundPlayerActionPacket$Action;
        static readonly DROP_ALL_ITEMS: Internal.ServerboundPlayerActionPacket$Action;
        static readonly RELEASE_USE_ITEM: Internal.ServerboundPlayerActionPacket$Action;
        static readonly START_DESTROY_BLOCK: Internal.ServerboundPlayerActionPacket$Action;
        static readonly ABORT_DESTROY_BLOCK: Internal.ServerboundPlayerActionPacket$Action;
        static readonly STOP_DESTROY_BLOCK: Internal.ServerboundPlayerActionPacket$Action;
        static readonly SWAP_ITEM_WITH_OFFHAND: Internal.ServerboundPlayerActionPacket$Action;
    }
    type ServerboundPlayerActionPacket$Action_ = ServerboundPlayerActionPacket$Action | "drop_item" | "drop_all_items" | "abort_destroy_block" | "start_destroy_block" | "release_use_item" | "swap_item_with_offhand" | "stop_destroy_block";
    interface Renderable {
        abstract render(arg0: Internal.GuiGraphics_, arg1: number, arg2: number, arg3: number): void;
        (arg0: Internal.GuiGraphics, arg1: number, arg2: number, arg3: number): void;
    }
    type Renderable_ = Renderable;
    interface PlayerDisplayNameCache {
        abstract clearCachedDisplayName(): void;
        (): void;
    }
    type PlayerDisplayNameCache_ = PlayerDisplayNameCache;
    interface ClientTooltipComponent {
        create($$0: Internal.FormattedCharSequence_): this;
        create($$0: Internal.TooltipComponent_): this;
        renderText($$0: net.minecraft.client.gui.Font_, $$1: number, $$2: number, $$3: Matrix4f_, $$4: Internal.MultiBufferSource$BufferSource_): void;
        abstract getHeight(): number;
        renderImage($$0: net.minecraft.client.gui.Font_, $$1: number, $$2: number, $$3: Internal.GuiGraphics_): void;
        abstract getWidth(arg0: net.minecraft.client.gui.Font_): number;
        get height(): number
    }
    type ClientTooltipComponent_ = ClientTooltipComponent;
    class FluidTankMountedStorageType extends Internal.MountedFluidStorageType<Internal.FluidTankMountedStorage> {
        constructor()
        mount(level: Internal.Level_, state: Internal.BlockState_, pos: BlockPos_, be: Internal.BlockEntity_): Internal.FluidTankMountedStorage;
    }
    type FluidTankMountedStorageType_ = FluidTankMountedStorageType;
    class DecimalStyle {
        static getAvailableLocales(): Internal.Set<Internal.Locale>;
        getDecimalSeparator(): string;
        getNegativeSign(): string;
        withZeroDigit(arg0: string): this;
        getPositiveSign(): string;
        withNegativeSign(arg0: string): this;
        getZeroDigit(): string;
        static ofDefaultLocale(): Internal.DecimalStyle;
        static of(arg0: Internal.Locale_): Internal.DecimalStyle;
        withPositiveSign(arg0: string): this;
        withDecimalSeparator(arg0: string): this;
        get availableLocales(): Internal.Set<Internal.Locale>
        get decimalSeparator(): string
        get negativeSign(): string
        get positiveSign(): string
        get zeroDigit(): string
        static readonly STANDARD: Internal.DecimalStyle;
    }
    type DecimalStyle_ = DecimalStyle;
    class CastingVM$Companion {
        constructor($constructor_marker: any_)
        empty(env: Internal.CastingEnvironment_): Internal.CastingVM;
    }
    type CastingVM$Companion_ = CastingVM$Companion;
    interface OptionEnum {
        abstract getKey(): string;
        getCaption(): net.minecraft.network.chat.Component;
        abstract getId(): number;
        get key(): string
        get caption(): net.minecraft.network.chat.Component
        get id(): number
    }
    type OptionEnum_ = OptionEnum;
    interface SheetGlyphInfo {
        getDown(): number;
        getRight(): number;
        abstract getPixelHeight(): number;
        getLeft(): number;
        abstract getOversample(): number;
        getBearingX(): number;
        abstract getPixelWidth(): number;
        getBearingY(): number;
        getUp(): number;
        abstract upload(arg0: number, arg1: number): void;
        abstract isColored(): boolean;
        get down(): number
        get right(): number
        get pixelHeight(): number
        get left(): number
        get oversample(): number
        get bearingX(): number
        get pixelWidth(): number
        get bearingY(): number
        get up(): number
        get colored(): boolean
    }
    type SheetGlyphInfo_ = SheetGlyphInfo;
    class Bat extends Internal.AmbientCreature {
        constructor($$0: Internal.EntityType_<Internal.Bat>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        isResting(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        static checkBatSpawnRules($$0: Internal.EntityType_<Internal.Bat>, $$1: Internal.LevelAccessor_, $$2: Internal.MobSpawnType_, $$3: BlockPos_, $$4: Internal.RandomSource_): boolean;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        method_5994(): Internal.SoundEvent;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        method_5776(): boolean;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        setResting($$0: boolean): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        get resting(): boolean
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set resting($$0: boolean)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        static readonly TICKS_PER_FLAP: 3;
        static readonly FLAP_DEGREES_PER_TICK: 74.48451;
    }
    type Bat_ = Bat;
}
declare namespace io.github.fabricators_of_create.porting_lib.transfer.fluid {
    class FluidTank extends Internal.SingleVariantStorage<Internal.FluidVariant> {
        constructor(fluid: Internal.FluidStack_, capacity: number)
        constructor(capacity: number)
        constructor(capacity: number, validator: Internal.Predicate_<Internal.FluidStack>)
        getResource(): any;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateExtract(resource: Internal.FluidVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        readFromNBT(tag: Internal.CompoundTag_): this;
        supportsInsertion(): boolean;
        setValidator(validator: Internal.Predicate_<Internal.FluidStack>): this;
        isEmpty(): boolean;
        iterator(): Internal.Iterator<Internal.StorageView<Internal.FluidVariant>>;
        writeToNBT(tag: Internal.CompoundTag_): Internal.CompoundTag;
        setCapacity(capacity: number): this;
        supportsExtraction(): boolean;
        getSlot(slot: number): Internal.SingleSlotStorage<Internal.FluidVariant>;
        getSlotCount(): number;
        forEach(arg0: Internal.Consumer_<Internal.StorageView<T>>): void;
        getSlots(): Internal.List<Internal.SingleSlotStorage<Internal.FluidVariant>>;
        spliterator(): Internal.Spliterator<Internal.StorageView<T>>;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateInsert(resource: Internal.FluidVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        isFluidValid(stack: Internal.FluidStack_): boolean;
        getFluid(): Internal.FluidStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        exactView(resource: Internal.FluidVariant_): Internal.StorageView<Internal.FluidVariant>;
        static asClass<T>(): Internal.Storage<T>;
        getUnderlyingView(): Internal.StorageView<Internal.FluidVariant>;
        insert(insertedVariant: Internal.FluidVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        nonEmptyViews(): Internal.Iterable<Internal.StorageView<Internal.FluidVariant>>;
        setFluid(fluid: Internal.FluidStack_): void;
        extract(extractedVariant: Internal.FluidVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        getSpace(): number;
        static empty<T>(): Internal.Storage<T>;
        getVersion(): number;
        nonEmptyIterator(): Internal.Iterator<Internal.StorageView<Internal.FluidVariant>>;
        getFluidAmount(): number;
        get resource(): any
        set validator(validator: Internal.Predicate_<Internal.FluidStack>)
        get empty(): boolean
        set capacity(capacity: number)
        get slotCount(): number
        get slots(): Internal.List<Internal.SingleSlotStorage<Internal.FluidVariant>>
        get fluid(): Internal.FluidStack
        get underlyingView(): Internal.StorageView<Internal.FluidVariant>
        set fluid(fluid: Internal.FluidStack_)
        get space(): number
        get version(): number
        get fluidAmount(): number
    }
    type FluidTank_ = FluidTank;
}
declare namespace net.p3pp3rf1y.sophisticatedcore.upgrades.filter {
    class Direction extends Internal.Enum<net.p3pp3rf1y.sophisticatedcore.upgrades.filter.Direction> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static values(): net.p3pp3rf1y.sophisticatedcore.upgrades.filter.Direction[];
        next(): this;
        getSerializedName(): string;
        static fromName(name: string): net.p3pp3rf1y.sophisticatedcore.upgrades.filter.Direction;
        static valueOf(name: string): net.p3pp3rf1y.sophisticatedcore.upgrades.filter.Direction;
        get serializedName(): string
        static readonly BOTH: net.p3pp3rf1y.sophisticatedcore.upgrades.filter.Direction;
        static readonly OUTPUT: net.p3pp3rf1y.sophisticatedcore.upgrades.filter.Direction;
        static readonly INPUT: net.p3pp3rf1y.sophisticatedcore.upgrades.filter.Direction;
    }
    type Direction_ = "both" | "output" | "input" | Direction;
}
declare namespace io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor {
    interface PackRepositoryAccessor {
        abstract getSources(): Internal.Set<Internal.RepositorySource>;
        get sources(): Internal.Set<Internal.RepositorySource>
        (): Internal.Set_<Internal.RepositorySource>;
    }
    type PackRepositoryAccessor_ = PackRepositoryAccessor;
}
declare namespace earth.terrarium.adastra.mixins.common {
    interface LivingEntityAccessor {
        abstract isJumping(): boolean;
        get jumping(): boolean
        (): boolean;
    }
    type LivingEntityAccessor_ = LivingEntityAccessor;
}
declare namespace net.mehvahdjukaar.moonlight.core.mixins.accessor {
    interface BrainAccessor <E extends Internal.LivingEntity> {
        abstract getAvailableBehaviorsByPriority(): Internal.Map<number, Internal.Map<Internal.Activity, Internal.Set<Internal.Behavior<E>>>>;
        abstract getSensors(): Internal.Map<Internal.SensorType<Internal.Sensor<E>>, Internal.Sensor<E>>;
        get availableBehaviorsByPriority(): Internal.Map<number, Internal.Map<Internal.Activity, Internal.Set<Internal.Behavior<E>>>>
        get sensors(): Internal.Map<Internal.SensorType<Internal.Sensor<E>>, Internal.Sensor<E>>
    }
    type BrainAccessor_<E extends Internal.LivingEntity> = BrainAccessor<E>;
}
